(function($, document) {

    var jckwds = {

        cache: function() {
            jckwds.els = {};
            jckwds.vars = {};

            // common elements
            jckwds.els.document                           = $(document);
            jckwds.els.document_body                      = $(document.body);
            jckwds.els.reservation_table                  = $('.jckwds-reserve');
            jckwds.els.reservation_table_rows             = jckwds.els.reservation_table.find('tr');
            jckwds.els.reservation_table_prev             = $('.jckwds-prevday');
            jckwds.els.reservation_table_next             = $('.jckwds-nextday');

            jckwds.els.date_picker                        = $("#jckwds-delivery-date");
            jckwds.els.timeslot_select                    = $('#jckwds-delivery-time');
            jckwds.els.timeslot_select_wrapper            = $('#jckwds-delivery-time-wrapper');
            jckwds.els.timeslot_field_row                 = $('#jckwds-delivery-time_field');

            jckwds.els.checkout_fields                    = $('#jckwds-fields');
            jckwds.els.ship_to_different_address_checkbox = $('#ship-to-different-address-checkbox');
            jckwds.els.shipping_postcode_field            = $('#shipping_postcode');
            jckwds.els.billing_postcode_field             = $('#billing_postcode');

            jckwds.els.multi_step_checkout                = $('#wizard');

            // common vars
            jckwds.vars.is_checkout                       = jckwds.els.document_body.hasClass('woocommerce-checkout');
            jckwds.vars.has_multi_step                    = jckwds.els.multi_step_checkout.length > 0 ? true : false;

        },

        on_ready: function() {

            // on ready stuff here
            jckwds.cache();

            jckwds.setup_reservation_table();
            jckwds.setup_checkout();
            jckwds.setup_multi_step_checkout();

        },



    /** =============================
        *
        * Reservation Table: Functions to run for the reservation table
        *
        ============================= */

        setup_reservation_table: function() {

            if( jckwds.els.reservation_table.length <= 0 ) {
                return;
            }

            jckwds.setup_prev_next();
            jckwds.setup_reserve_button();

        },

    /** =============================
        *
        * Checkout: Functions to run on checkout
        *
        ============================= */

        setup_checkout: function() {

            if( !jckwds.vars.is_checkout || jckwds.vars.has_multi_step ) { return; }

            jckwds.setup_checkout_fields();
            jckwds.watch_postcode_fields();
            jckwds.watch_update_checkout();

        },

    /** =============================
        *
        * Checkout: If multi step checkout is enabled
        *
        ============================= */

        setup_multi_step_checkout: function() {

            if( !jckwds.vars.is_checkout || !jckwds.vars.has_multi_step ) { return; }

            jckwds.els.multi_step_checkout.on('init', function(){

                jckwds.cache();
                jckwds.setup_checkout_fields();
                jckwds.watch_postcode_fields();
                jckwds.watch_update_checkout();

            });

        },




    /** =============================
        *
        * Reservation Table: Setup Prev/Next buttons on reservation table
        *
        ============================= */

        setup_prev_next: function() {

            jckwds.els.reservation_table_prev.on('click', function(){

                $.each( jckwds.els.reservation_table_rows, function(){

                    var $firstVisIndex = $(this).find('.colVis:first').index();

                    if($firstVisIndex !== 1){

                        $(this).children().eq($firstVisIndex-1).addClass('colVis');
                        $(this).find('.colVis:last').removeClass('colVis');

                    }

                });

                return false;

            });

            jckwds.els.reservation_table_next.on('click', function(){

                var $lastVisIndex = $('.jckwds-reserve thead tr .colVis:last').index(),
                    $firstVisIndex = $('.jckwds-reserve thead tr .colVis:first').index();

                $.each( jckwds.els.reservation_table_rows, function(){

                    var $lastVisIndex = $(this).find('.colVis:last').index();

                    if($lastVisIndex+1 < $(this).children().length){

                        $(this).children().eq($lastVisIndex+1).addClass('colVis');
                        $(this).find('.colVis:first').removeClass('colVis');

                    }

                });

                return false;

            });

        },

    /** =============================
        *
        * Reservation Table: Setup reservation table reserve button
        *
        ============================= */

        setup_reserve_button: function(){

            jckwds.els.document.on('click', '.jckwds-reserve-slot', function(){

                jckwds.activate_slot( $(this) );
                return false;

            });

        },

    /** =============================
        *
        * Reservation Table: Activate the clicked slot
        *
        ============================= */

        activate_slot: function( $the_slot ){

            var $slot_parent = $the_slot.parent(),
                cell_data = $slot_parent.html(),
                slot_id = $slot_parent.attr('data-timeslot-id'),
                slot_date = $slot_parent.attr('data-timeslot-date'),
                slot_start_time = $slot_parent.attr('data-timeslot-start-time'),
                slot_end_time = $slot_parent.attr('data-timeslot-end-time'),
                $table_wrap = $the_slot.closest('.jckwds-reserve-wrap'),
                loader = '<div class="jckwds_loading"><i class="jckwds-icn-loading animate-spin"></i></div>',
                remove_reserved_data = {
                    action: 'jckwds_remove_reserved_slot',
                    nonce: jckwds_vars.ajax_nonce
                };

            $the_slot.hide().after( loader );

            jQuery.post( jckwds_vars.ajax_url, remove_reserved_data, function( response ) {

                if( response.success ){

                    jckwds.els.document_body.trigger('reservation_removed');

                    var reserve_data = {
                        action: 'jckwds_reserve_slot',
                        nonce: jckwds_vars.ajax_nonce,
                        slot_id: slot_id,
                        slot_date: slot_date,
                        slot_start_time: slot_start_time,
                        slot_end_time: slot_end_time
                    };

                    jQuery.post(jckwds_vars.ajax_url, reserve_data, function( response ) {

                        if(response.success){

                            jckwds.els.document_body.trigger('reservation_added');

                            $('td.jckwds-reserved').removeClass('jckwds-reserved');
                            $slot_parent.addClass('jckwds-reserved').html( cell_data );

                        }

                    });

                }

            });

        },



    /** =============================
        *
        * Checkout: Setup date/time fields
        *
        ============================= */

        setup_checkout_fields: function() {
            jckwds.setup_date_picker();
            jckwds.setup_timeslot_select();
        },

    /** =============================
        *
        * Checkout: Setup date_picker
        *
        ============================= */

        setup_date_picker: function(){

            /* Prepare holidays in an easier to read, simple array */

            var holidays = jckwds_vars.settings.holidays_holidays_holidays,
                holiday_array = [];

            $.each(holidays, function(index, value){

                holiday_array.push(value.date.date);

            });

            /* Initiate Date picker */

            jckwds.els.date_picker.datepicker({
                minDate: "+"+jckwds_vars.settings.datesettings_datesettings_minimum+"D",
                maxDate: "+"+jckwds_vars.settings.datesettings_datesettings_maximum+"D",
                beforeShowDay: function(date){

                    var formatted_date = $.datepicker.formatDate('dd/mm/yy', date);

                    if( $.inArray(formatted_date, jckwds_vars.bookable_dates) !== -1 ) {
                        return [true, "","Available"];
                    } else {
                        return [false, "","unAvailable"];
                    }

                },
                dateFormat: jckwds_vars.settings.datesettings_datesettings_dateformat,
                onSelect: function(dateText) {

                    /* Trigger change event */
                    $(this).trigger('change');

                    // if time slots are enabled
                    if(jckwds_vars.settings.timesettings_timesettings_setup_enable){

                        if( this.value !== "" ) {
                            /* timeslot lookup after date selection */
                            jckwds.update_timeslot_options( this.value );
                        }

                    }

                },
                monthNames: jckwds_vars.strings.months,
                monthNamesShort: jckwds_vars.strings.months_short,
                dayNames: jckwds_vars.strings.days,
                dayNamesMin: jckwds_vars.strings.days_short
            });

        },

    /** =============================
        *
        * Helper: Get all timeslots available on a specific date,
        *         and update the timeslots dropdown
        *
        * @param [str] [date] [format?]
        * @param [func] [callback]
        *
        ============================= */

        update_timeslot_options: function( date, callback ){

            var $first_timeslot_option = jckwds.els.timeslot_select.find("option:eq(0)"),
                postcode = ( jckwds.els.ship_to_different_address_checkbox.is(":checked") ? $('#shipping_postcode').val() : $('#billing_postcode').val() );

            jckwds.els.timeslot_select.find("option:gt(0)").remove();
            $first_timeslot_option.text(jckwds_vars.strings.loading);

            jckwds.els.timeslot_select.trigger('change');

            var ajaxData = {
                action: 'jckwds_slots_on_date',
                nonce: jckwds_vars.ajax_nonce,
                date: date,
                postcode: postcode
            };

            jQuery.post(jckwds_vars.ajax_url, ajaxData, function(response) {

                if(response.success === true){

                    $first_timeslot_option.text(jckwds_vars.strings.selectslot);
                    jckwds.els.timeslot_select.append(response.html);

                    jckwds.els.document_body.trigger('timeslots_loaded');
                    jckwds.els.document_body.trigger('update_checkout');

                    if( response.reservation ) {
                        if( jckwds.els.timeslot_select.find("option[value='"+response.reservation+"']").length > 0 ) {
                            jckwds.els.timeslot_select.val(response.reservation);
                        }
                    }

                } else {

                    $first_timeslot_option.text(jckwds_vars.strings.noslots);

                }

                jckwds.els.timeslot_select.trigger('change');

                if(callback !== undefined) {
        			callback();
        		}

            });

        },

    /** =============================
        *
        * Checkout: Refresh time slots
        *
        * @param [bool] [postcode_changed]
        *
        ============================= */

        refresh_timeslots: function( postcode_changed ) {

            postcode_changed = typeof postcode_changed !== 'undefined' ? postcode_changed : false;

            // if a reservation is in place, don't refresh timeslots

            if(
                jckwds.els.timeslot_field_row.hasClass('jckwds-delivery-time--has-reservation') &&
                postcode_changed === false
            ) {
                jckwds.els.timeslot_field_row.removeClass('jckwds-delivery-time--has-reservation');
                return;
            }

            // refresh timeslots, based on date

            var date = jckwds.els.date_picker.val();

            if( date !== "" ) {
                jckwds.update_timeslot_options( date );
            }

        },

    /** =============================
        *
        * Checkout: Watch postcode fields for changes
        *
        ============================= */

        watch_postcode_fields: function() {

            jckwds.els.ship_to_different_address_checkbox.on('change', function(){
                jckwds.refresh_timeslots();
            });

            jckwds.els.billing_postcode_field.on('change', function(){
                if(
                    !jckwds.els.ship_to_different_address_checkbox.is(":checked") ||
                    jckwds.els.shipping_postcode_field.length <= 0
                ) {
                    jckwds.refresh_timeslots( true );
                }
            });

            jckwds.els.shipping_postcode_field.on('change', function(){
                jckwds.refresh_timeslots( true );
            });

        },

    /** =============================
        *
        * Checkout: Setup timeslot field
        *
        ============================= */

        setup_timeslot_select: function() {

            // update checkout on time selection

            jckwds.els.timeslot_select_wrapper.on('change', function(){
                jckwds.els.document_body.trigger('update_checkout');
            });

        },

    /** =============================
        *
        * Checkout: Watch for the update_checkout trigger
        *
        ============================= */

        watch_update_checkout: function() {

            jckwds.els.document_body.on( 'updated_checkout', function(){

                var activate_date_time_fields = jckwds.check_if_activated_for_shipping_method(),
                    $fields_placeholder = $('.jckwds-fields-placeholder');

                if( activate_date_time_fields === false ) {

                    if( $fields_placeholder.length <= 0 ) {

                        jckwds.els.checkout_fields
                        .hide()
                        .after('<div class="jckwds-fields-placeholder"></div>')
                        .appendTo('body');

                    }

                } else {

                    if( $fields_placeholder.length > 0 ) {
                        $fields_placeholder.replaceWith( jckwds.els.checkout_fields.show() );
                    }

                }

            } );

        },

    /** =============================
        *
        * Checkout: Check if date/time is activated for selected shipping method
        *
        * @return [bool]
        *
        ============================= */

        check_if_activated_for_shipping_method: function() {

            if( jckwds_vars.settings.general_setup_shipping_methods[0] === "any" ) {
                return true;
            }

            if(
                typeof jckwds_vars.settings.general_setup_shipping_methods === "undefined" ||
                $.isEmptyObject( jckwds_vars.settings.general_setup_shipping_methods ) ||
                $('.shipping_method').length <= 0
            ) {
                return false;
            }

            var shipping_method_value = $('.shipping_method').length > 1 ? $('.shipping_method:checked', 'form.checkout').val() : $('.shipping_method', 'form.checkout').val(),
                method_found = false;

            $.each( jckwds_vars.settings.general_setup_shipping_methods, function( key, shipping_method ) {
                if( shipping_method_value.replace("wc_shipping_", "") === shipping_method.replace("wc_shipping_", "") ) {
                    method_found = true;
                }
            });

            return method_found;

        },

    /** =============================
        *
        * Checkout: Clear date/time fields
        *
        ============================= */

        clear_date_time_fields: function() {

            $.datepicker._clearDate( jckwds.els.date_picker );

        }

    };

	$(document).ready( jckwds.on_ready() );

}(jQuery, document));