<?php
/**
* Admin Main Class
***********************************/
if ( ! defined( 'WPINC' ) ) die;
if ( ! class_exists( 'DTC_mCommerce_Admin' ) ) die;	

class DTC_mCommerce_Admin {
	protected static $instance = null;
	protected $page_tabs = array();

	public function __construct() {
		$this->globals = DTC_mCommerce_Core::instance();

		add_action( 'admin_head', array($this, 'hook_css') );
		add_action( 'admin_menu', array($this, 'menu_options') );;

		add_action( 'wp_ajax_dtcmc_settings_action', array($this, 'ajax_settings_process') );
		add_action( 'wp_ajax_dtcmc_images_action', array($this, 'ajax_image_process') );
		add_action( 'admin_enqueue_scripts', array($this, 'enqueue_scripts') );
	}

	public static function instance() {
		if ( self::$instance == null ) self::$instance = new self;
		return self::$instance;
	}

	public function menu_options() {
		add_menu_page( $this->globals['plugin_name'], $this->globals['plugin_name'], 'manage_options', $this->globals['plugin_slug'], array($this, 'options_page'), $this->globals['plugin_url'].'assets/images/nav-icon.png', 50 );
	}

	public function options_page() {
		if( ! current_user_can('manage_options') )	{
			wp_die(__('You do not have sufficient permissions to access this page.'));
		}

		include_once( $this->globals['plugin_path'] . 'admin/views/page-settings.php' );
	}

	public function ajax_settings_process() {
		// Check Nonce
		if ( ! isset( $_POST['dtcmc_settings_nonce'] ) || !wp_verify_nonce($_POST['dtcmc_settings_nonce'], 'dtcmc_settings_action') )
			die('Permission Denied');

		$settings_options = get_option( $this->globals['settings_option_key'] );

		$settings_options['enable_mcommerce'] = (int)$_POST["enable_mcommerce"];
		$settings_options['force_save'] = (int)$_POST["force_save"];
		$settings_options['site_title'] = trim($_POST["site_title"]);

		$settings_options['favicon']['win_tile'] = $_POST["win_tile_color"];

		$settings_options['color_scheme']['body_bg_color'] = trim($_POST["body_bg_color"]);
		$settings_options['color_scheme']['primary_color'] = trim($_POST["primary_color"]);
		$settings_options['color_scheme']['link_color'] = trim($_POST["link_color"]);
		$settings_options['color_scheme']['address_bar'] = trim($_POST["address_bar"]);
		$settings_options['color_scheme']['button_bg_color'] = trim($_POST["button_bg_color"]);
		$settings_options['color_scheme']['button_text_color'] = trim($_POST["button_text_color"]);
		$settings_options['color_scheme']['navbar_bg_color'] = trim($_POST["navbar_bg_color"]);
		$settings_options['color_scheme']['navbar_text_color'] = trim($_POST["navbar_text_color"]);
		$settings_options['color_scheme']['cart_badge_bg_color'] = trim($_POST["cart_badge_bg_color"]);
		$settings_options['color_scheme']['cart_badge_text_color'] = trim($_POST["cart_badge_text_color"]);
		$settings_options['color_scheme']['label_bg_color'] = trim($_POST["label_bg_color"]);
		$settings_options['color_scheme']['label_text_color'] = trim($_POST["label_text_color"]);

		$settings_options['layouts']['home'] = trim($_POST["layout_home"]);
		$settings_options['layouts']['category'] = trim($_POST["layout_category"]);
		$settings_options['layouts']['cart'] = trim($_POST["layout_cart"]);

		$settings_options['layouts']['android_navigation'] = $_POST["android_navigation"];
		$settings_options['layouts']['ios_navigation'] = $_POST["ios_navigation"];

		$settings_options['analytics'] = stripslashes( trim($_POST["tracking_code"]) );

		$settings_options['custom_code']['css'] = stripslashes( trim($_POST["custom_css"]) );
		$settings_options['custom_code']['js'] = stripslashes( trim($_POST["custom_js"]) );

		$do_change = update_option( $this->globals['settings_option_key'], $settings_options );

		echo json_encode( array('success' => true, 'message' => 'Changes were successfully updated.</span>') );
		
		die();
	}

	public function ajax_image_process() {
		// Check Nonce
		if ( ! isset( $_POST['nonce'] ) || !wp_verify_nonce($_POST['nonce'], 'dtcmc_images_nonce') )
			die('Permission Denied');

		$settings_options = get_option( $this->globals['settings_option_key'] );

		// We are doing an image upload
		if ( $_POST['method'] == 'upload' ) {
			
			$upload_dir = wp_upload_dir();
			$date_format = date( 'Y/m', strtotime( $_POST["file_date"] ) );

			// Site logo
			if ( $_POST['input_name'] == 'site_logo' ) {
				$settings_options['site_logo'] = $_POST["file_url"];
				update_option( $this->globals['settings_option_key'], $settings_options );

				die();
			}

			// Favicons
			if ( $_POST['input_name'] == 'favicon' ) {
				$file = ''.$upload_dir['basedir'].'/'.$date_format.'/'.$_POST["file_name"];
				$raw_filename = pathinfo($file, PATHINFO_FILENAME);

				$settings_options['favicon']['url'] = $upload_dir['baseurl'].'/'.$date_format.'/';
				$settings_options['favicon']['name'] = $raw_filename;
				
				update_option( $this->globals['settings_option_key'], $settings_options );

				// resize the image
				$sizes_array = 	array(
					array ('width' => 16, 'height' => 16, 'crop' => false),
					array ('width' => 32, 'height' => 32, 'crop' => false),
					array ('width' => 57, 'height' => 57, 'crop' => false),
					array ('width' => 60, 'height' => 60, 'crop' => false),
					array ('width' => 72, 'height' => 72, 'crop' => false),
					array ('width' => 76, 'height' => 76, 'crop' => false),
					array ('width' => 96, 'height' => 96, 'crop' => false),
					array ('width' => 114, 'height' => 114, 'crop' => false),
					array ('width' => 120, 'height' => 120, 'crop' => false),
					array ('width' => 144, 'height' => 144, 'crop' => false),
					array ('width' => 152, 'height' => 152, 'crop' => false),
					array ('width' => 180, 'height' => 180, 'crop' => false),
					array ('width' => 192, 'height' => 192, 'crop' => false)
				);

				DTC_mCommerce_Helper::image_editor( $method = 'resize', $file, $sizes_array );

				die();
			}

			// Home Slider One
			if ( $_POST['input_name'] == 'home_slider_one' ) {
				$settings_options['home_slider']['one'] = $_POST["file_url"];
				update_option( $this->globals['settings_option_key'], $settings_options );

				die();
			}

			// Home Slider Two
			if ( $_POST['input_name'] == 'home_slider_two' ) {
				$settings_options['home_slider']['two'] = $_POST["file_url"];
				update_option( $this->globals['settings_option_key'], $settings_options );

				die();
			}

			// Home Slider Three
			if ( $_POST['input_name'] == 'home_slider_three' ) {
				$settings_options['home_slider']['three'] = $_POST["file_url"];
				update_option( $this->globals['settings_option_key'], $settings_options );

				die();
			}
		} 
		// we are deleting an image
		else if ( $_POST['method'] == 'delete' ) {
			$file_url = $settings_options[$_POST["input_name"]];

			if ( $_POST["input_name"] == "site_logo" ) {
				$settings_options[$_POST["input_name"]] = '';
			}
			else if ( $_POST["input_name"] == "favicon" ) {
				$favicon = $settings_options[$_POST["input_name"]];
				$file_url = $favicon['url'].''.$favicon['name'].'.png';

				// reset options
				$settings_options['favicon']['url'] = '';
				$settings_options['favicon']['name'] = '';
			} 
			else if ( $_POST["input_name"] == "home_slider_one" ) {
				$settings_options['home_slider']['one'] = '';
			}
			else if ( $_POST["input_name"] == "home_slider_two" ) {
				$settings_options['home_slider']['two'] = '';
			}
			else if ( $_POST["input_name"] == "home_slider_three" ) {
				$settings_options['home_slider']['three'] = '';
			}

			update_option( $this->globals['settings_option_key'], $settings_options );
		}

		die();
	}

	public function enqueue_scripts() {
		if ( isset( $_GET['page'] ) && strpos( $_GET['page'], $this->globals['plugin_slug'] ) !== false ) {
			wp_enqueue_media();

			wp_enqueue_style( $this->globals['plugin_prefix'] . 'bootstrap_style', $this->globals['plugin_url'] . 'assets/css/bootstrap.min.css' );
			wp_enqueue_style( $this->globals['plugin_prefix'] . 'core_style', $this->globals['plugin_url'] . 'assets/css/core.min.css' );
			wp_enqueue_style( $this->globals['plugin_prefix'] . 'admin_style', $this->globals['plugin_url'] . 'assets/css/style.css' );

			wp_enqueue_script( $this->globals['plugin_prefix'] . 'bootstrap_script', $this->globals['plugin_url'] . 'assets/js/bootstrap.min.js');
			wp_enqueue_script( $this->globals['plugin_prefix'] . 'core_script', $this->globals['plugin_url'] . 'assets/js/core.min.js');
			wp_enqueue_script( $this->globals['plugin_prefix'] . 'ace_script', $this->globals['plugin_url'] . 'assets/js/ace/ace.js');
			wp_enqueue_script( $this->globals['plugin_prefix'] . 'admin_script', $this->globals['plugin_url'] . 'assets/js/app.js', array('jquery') );

			wp_localize_script($this->globals['plugin_prefix'] . 'admin_script', 'dtcmc_admin_vars', array(
					'dtcmc_images_action' => wp_create_nonce('dtcmc_images_nonce')
				)
			);
		}
	}

	public function hook_css() {
		$output = "<style>#adminmenu #toplevel_page_dtc-mcommerce .wp-menu-image img{padding-top:5px!important}</style>";
		echo $output;
	}

}
?>