jQuery(document).ready(function($){

    if( $("#css_editor").get(0) || $("#javascript_editor").get(0) ) {
        var customCSS = ace.edit("css_editor"); 
        var customJS = ace.edit("javascript_editor");
    }


    // Clear error message on click
    $('#btn-clear-msg').click(function() {
        var ID = $(this).data("id");
        messageClear( ID )
    });


    // Activation form ajax
    $('#form-activation').submit(function(e) {
        e.preventDefault();

        var spinner = Ladda.create( document.querySelector( '.save-spinner' ) );
        var formData = $("#form-activation").serialize();
        
        messageClear( 'response-activation' );
        $.ajax({
            url : ajaxurl,
            type: "POST",
            data : formData,
            
            beforeSend: function() {
                spinner.start()
            },
            success:function(response) {
                //console.log(response);
                var oRtn = eval('('+response+')');
                messageDisplay( 'response-activation', oRtn.message, oRtn.success );

                if ( oRtn.success == true ) {
                    setTimeout(function(){
                    window.location= oRtn.redirect_url;
                    }, 500);
                }
            },
            complete: function() {
                spinner.stop();
            }
        })

        return false;
    });


    // Settings form ajax
    $('#form-settings').submit(function(e) {
        e.preventDefault();

        var spinner = Ladda.create( document.querySelector( '.save-spinner' ) );
        var formData = $("#form-settings").serialize();
        formData += "&custom_css=" + encodeURIComponent(customCSS.getValue()) + "&custom_js=" + encodeURIComponent(customJS.getValue());

        $.ajax({
            url : ajaxurl,
            type: "POST",
            data : formData,
            
            beforeSend: function() {
                spinner.start()
            },
            success:function(response) {
                var oRtn = eval('('+response+')');
                messageDisplay( 'response-settings', oRtn.message, oRtn.success );

                setTimeout(function() {
                    $('#response-settings').fadeOut('slow');
                }, 5000);
            },
            complete: function() {
                spinner.stop();
            }
        })

        return false;
    });


    // Settings form ajax
    $('#form-update-core').submit(function(e) {
        e.preventDefault();

        var spinner = Ladda.create( document.querySelector( '.save-spinner' ) );
        var formData = $("#form-update-core").serialize();
        
        $.ajax({
            url : ajaxurl,
            type: "POST",
            data : formData,
            
            beforeSend: function() {
                spinner.start()
            },
            success:function(response) {
                //console.log(response);
                var oRtn = eval('('+response+')');
                messageDisplay( 'response-update', oRtn.message, oRtn.success );
            },
            complete: function() {
                spinner.stop();
            }
        })

        return false;
    });


    // Upload Images
    $('.action-image-upload').click(function() {
        var media_uploader;
        var parentIdentifier = $(this).data("identifier");

        // If the media frame already exists, reopen it.
        if ( media_uploader ) {
            media_uploader.open();
            return;
        }
    
        // Create a new media frame
        media_uploader = wp.media({
            title: 'WooMobify - Upload Images',
            button: {
            text: 'Use this image'
        },
            multiple: false
        });

        // When an image is selected
        media_uploader.on( 'select', function() {
            var json_data = media_uploader.state().get("selection").first().toJSON();

            // Validation
            $('#' + parentIdentifier + '-error').attr('style', 'display: block;');

            if ( parentIdentifier == 'favicon' ) {
                if ( json_data.subtype != 'png' ) {
                    $('#' + parentIdentifier + '-error').html('Only PNG format is supported.');
                    return;
                }
                if ( json_data.height != json_data.width ) {
                    $('#' + parentIdentifier + '-error').html('The image must be a square, same height and width.');
                    return;
                }
            }

            $('#' + parentIdentifier + '-preview').fadeIn();
            $('#' + parentIdentifier + '-preview img').attr('src', json_data.url);
            $('#' + parentIdentifier + '-error').fadeOut();
            $('#' + parentIdentifier + '-delete').fadeIn();

            // Send the image data for processing
            var formData = "action=dtcmc_images_action&method=upload&input_name="+ encodeURIComponent(parentIdentifier) +"&file_name="+ encodeURIComponent(json_data.filename) +"&file_date="+ encodeURIComponent(json_data.dateFormatted) +"&nonce=" + encodeURIComponent(dtcmc_admin_vars.dtcmc_images_action) + "&file_url="+ encodeURIComponent(json_data.url);

            $.ajax({
                url : ajaxurl,
                type: "POST",
                data : formData,
                success:function( response ) {
                    //console.log(response);
                }
            })
        });

        media_uploader.open();
    });


    // Remove uploaded images
    $('.action-image-delete').click(function() {
        var parentIdentifier = $(this).data("identifier");
        var spinner = Ladda.create( document.querySelector( '#' + $(this).attr("id") ));
        var formData = "action=dtcmc_images_action&method=delete&input_name=" + encodeURIComponent(parentIdentifier) + "&nonce=" + encodeURIComponent(dtcmc_admin_vars.dtcmc_images_action);

        $.ajax({
            url : ajaxurl,
            type: "POST",
            data : formData,
            
            beforeSend: function() {
                spinner.start();
            },
            success:function(response) {
                $('#' + parentIdentifier + '-preview').fadeOut();
                $('#' + parentIdentifier + '-delete').fadeOut();
            },
            complete: function() {
                spinner.stop();
            }
        })

        return false;
    });


    // Switchery
    var elems = Array.prototype.slice.call(document.querySelectorAll('.switchery'));
    elems.forEach(function(html) {
        var switchery = new Switchery(html, { color: '#00A5C4' });
    });


    // Checkboxes/radios (Uniform)
    $(".styled, .multiselect-container input").uniform({
        radioClass: 'choice'
    });


    // Spectrum color picker
    $(".colorpicker-show").spectrum({
        showInput: true
    });


    // CSS editor
    if( $("#css_editor").get(0) ) {
        customCSS.setTheme("ace/theme/monokai");
        customCSS.getSession().setMode("ace/mode/css");
        customCSS.setShowPrintMargin(false);
    }


    // Javascript editor
    if( $("#javascript_editor").get(0) ) {
        customJS.setTheme("ace/theme/monokai");
        customJS.getSession().setMode("ace/mode/javascript");
        customJS.setShowPrintMargin(false);
    }

    // Tooltip
    $('[data-popup="tooltip"]').tooltip();

    // Popover
    $('[data-popup="popover"]').popover();


    function messageClear( alertID ) {
        $('#'+alertID +'.alert-success').removeClass().hide();
        $('#'+alertID +'.alert-danger').removeClass().hide();
    }   

    function messageDisplay( alertID, alertText, alertResponse ) {
        newClass = 'alert alert-styled-left alert-arrow-left alert-bordered alert-'+((alertResponse) ? 'success' : 'danger');
        $('#'+alertID).find('span#msg').html(alertText);
        $('#'+alertID).addClass(newClass).show(700);
    }
});