<?php
/**
* Helper Class - Globally use functions
***********************************************/
if ( ! defined( 'WPINC' ) ) die;
if ( ! class_exists( 'DTC_mCommerce_Helper' ) ) die;	

class DTC_mCommerce_Helper {
	protected static $instance = null;

	public function __construct() {

	}

	public static function instance() {
		if ( self::$instance == null ) self::$instance = new self;
		return self::$instance;
	}

	public static function settings_default_options() {
		$settings_options = array(
			'enable_mcommerce' => 1,
			'force_save' => 0,
			'site_logo' => '',
			'site_title' => get_bloginfo('name'),
			'analytics' => '',
			'favicon' => array(
				'url' => '',
				'name' => '',
				'win_tile' => ''
			),
			'home_slider' => array(
				'one' => '',
				'two' => '',
				'three' => ''
			),
			'color_scheme' => array(	
				'body_bg_color' => '',
				'primary_color' => '',
				'link_color' => '',
				'address_bar' => '',
				'button_bg_color' => '',
				'button_text_color' => '',
				'cart_badge_bg_color' => '',
				'cart_badge_text_color' => '',
				'label_bg_color' => '',
				'label_text_color' => '',
				'navbar_bg_color' => '',
				'navbar_text_color' => ''
			),
			'custom_code' => array(
				'css' => '',
				'js' => ''
			),
			'layouts' => array(
				'android_navigation' => 'sidepanel',
				'ios_navigation' => 'bottombar',
				'bottombar' => '',
				'sidepanel' => '',
				'home' => '',
				'catalog' => '',
				'category' => '',
				'view-product' => '',
				'search' => '',
				'view_product' => '',
				'cart' => ''
			)
		);
		return $settings_options;
	}

	public static function core_default_options() {
		$core_options = array(
			'api_key_id' => '',
			'api_consumer_key' => '',
			'api_consumer_secret' => ''
		);
		return $core_options;
	}

	public static function image_editor( $method, $file, $resize_sizes = NULL) {
		$image = wp_get_image_editor( $file );

		// Resize method
		if ( $method = 'resize') {
			if ( ! is_wp_error( $image ) ) {
				$resize = $image->multi_resize( $resize_sizes );
				return $resize;
			} else {
				return false;
			}
		}

		return;
	}

    /**
     * Delete a directory
     * Download a a directory and all files
     * @param dir_path - path to the directory
     *-------------------------------------------- */
	public static function delete_dir( $dir_path ) {
		if( is_dir($dir_path) ) {

		    if (substr($dir_path, strlen($dir_path) - 1, 1) != '/') {
		        $dir_path .= '/';
		    }

		    $files = glob($dir_path . '*', GLOB_MARK);
		    foreach ($files as $file) {
		        if (is_dir($file)) {
		            self::delete_dir($file);
		        } else {
		            unlink($file);
		        }
		    }
		    rmdir($dir_path);
		}
	}

	/**
     * Remove an API key
     * Download a a directory and all files
     * @param int $key_id
     * @return bool
     *-------------------------------------------- */
	public static function remove_api_key( $key_id ) {
		global $wpdb;

		$delete = $wpdb->delete( $wpdb->prefix . 'woocommerce_api_keys', array( 'key_id' => $key_id ), array( '%d' ) );

		return $delete;
	}
}
?>