<?php
/**
* Mobile Theme Class - Use for mobile theme ajax functions
***********************************************/
if ( ! defined( 'WPINC' ) ) die;
if ( ! class_exists( 'DTC_mCommerce_Mobile' ) ) die;	

class DTC_mCommerce_Mobile {
	protected static $instance = null;

	public function __construct() {
		add_action('wp_ajax_dtcmc_action_cart', array($this, 'dtcmc_action_cart_ajax'));
		add_action('wp_ajax_nopriv_dtcmc_action_cart', array($this, 'dtcmc_action_cart_ajax'));

		add_action('wp_ajax_dtcmc_action_product', array($this, 'dtcmc_action_product_ajax'));
		add_action('wp_ajax_nopriv_dtcmc_action_product', array($this, 'dtcmc_action_product_ajax'));

		add_action('wp_ajax_dtcmc_action_auth', array($this, 'dtcmc_action_auth_ajax'));
		add_action('wp_ajax_nopriv_dtcmc_action_auth', array($this, 'dtcmc_action_auth_ajax'));
	}

	public static function instance() {
		if ( self::$instance == null ) self::$instance = new self;
		return self::$instance;
	}


	/**
	 * Shopping Cart Ajax Calls
	 * Handles all shopping cart process
	 *-------------------------------------------- */
	public function dtcmc_action_cart_ajax() {
		// Security Checks
		/*if ( ! isset( $_POST['security'] ) || !wp_verify_nonce($_POST['security'], 'dtcmc_cart_nonce') )
			die('Permission Denied');*/

		if ( ! defined('WOOCOMMERCE_CART') ) {
        	define( 'WOOCOMMERCE_CART', true );
        }

        $json = array();
        $error = false;

        /**
		 * ENDPOINT - Add items to cart
		 * Add grouped products
		 * Add simple or variation
		 * @return Success or error
		 *-------------------------------------------- */
        if ( $_POST['endpoint'] == 'add_cart_item' ) {
        	$product_id 	= $_POST['product_id'];
			$quantity 		= $_POST['quantity'];
			$variation_id 	= $_POST['variation_id'];
			$variation 		= $_POST['variation'];

        	// Get the product data
			$product_data = wc_get_product( $variation_id ? $variation_id : $product_id );

			// Check product is_purchasable
			if ( ! $product_data->is_purchasable() && $_POST['type'] != 'grouped' ) {
				$json[] = 'Sorry, this product cannot be purchased.';
				$error = true;
			}
			else if ( ! $product_data->is_in_stock() ) {
				// Stock check - only check if we're managing stock and backorders are not allowed
				$json[] = sprintf('You cannot add &quot;%s&quot; to the cart because the product is out of stock.', $product_data->get_title() );
				$error = true;
			} 
			else if ( ! $product_data->has_enough_stock( $quantity ) ) {
        		// Stock check - inventory
				$json[] = sprintf('You cannot add that amount of &quot;%1$s&quot; to the cart because there is not enough stock (%2$s remaining).', $product_data->get_title(), $product_data->get_stock_quantity() );
				$error = true;
			}
			else if ( $managing_stock = $product_data->managing_stock() ) {
				// Stock check - in cart
				$products_qty_in_cart = WC()->cart->get_cart_item_quantities();

				if ( $product_data->is_type( 'variation' ) && true === $managing_stock ) {
					$check_qty = isset( $products_qty_in_cart[ $variation_id ] ) ? $products_qty_in_cart[ $variation_id ] : 0;
				} else {
					$check_qty = isset( $products_qty_in_cart[ $product_id ] ) ? $products_qty_in_cart[ $product_id ] : 0;
				}
				
				// Check stock based on all items in the cart.
				if ( ! $product_data->has_enough_stock( $check_qty + $quantity ) ) {
					$json[] = sprintf('You cannot add that amount to the cart. We have %1$s in stock and you already have %2$s in your cart.', $product_data->get_stock_quantity(), $check_qty );
					$error = true;
				}
			}
	
			if ( $error === false ) {
				if ( $_POST['type'] == 'grouped' ) {
	        		// Add grouped products
		        	if ( $_POST['grouped'] == null ) {
		        		$json[] = 'Please choose the quantity of items you wish to add to your cart.';
		        	} else {
			        	foreach ( $_POST['grouped'] as $key => $value ) {
			        		WC()->cart->add_to_cart( $key, $value );
			        	}
						$json['success'] = 1;
						$json['total_items'] = WC()->cart->get_cart_contents_count();
			        }
				} else {
					// add simple or variation product
		       		WC()->cart->add_to_cart( $product_id, $quantity, $variation_id, $variation );

		        	$json['success'] = 1;
		        	$json['total_items'] = WC()->cart->get_cart_contents_count();
	        	}
	        }
		}


        /**
		 * ENDPOINT - Get cart totals
		 * @return array with data
		 *-------------------------------------------- */
        if ( $_POST['endpoint'] == 'get_cart_totals' ) {
        	WC()->cart->calculate_totals();

			$data_array = array(
                    'total_items' => WC()->cart->get_cart_contents_count(),
                    //'sub_total'  => wc_price( WC()->cart->subtotal ),
                    'order_total' => wc_price( WC()->cart->total )
                );
            $json = $data_array;
		}


        /**
		 * ENDPOINT - Get cart items
		 * @return array with data
		 *-------------------------------------------- */
		if ( $_POST['endpoint'] == 'get_cart_items' ) {
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                $product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                
                // Product vars
                $thumbnail    = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image( array( 600, 600 ), array('class'=> 'img-responsive') ), $cart_item, $cart_item_key );
                $title        = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
                $unit_price   = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                $total_price  = apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
                $variation 	  = WC()->cart->get_item_data( $cart_item );
                //$max_quantity = $_product->backorders_allowed() ? '' : $_product->get_stock_quantity();

               	$item_data_array = array(
               			'product_id'	=> $product_id,
                        'title'			=> $title,
                        'unit_price'	=> $unit_price,
                        'total_price'	=> $total_price,
                        'thumbnail'		=> $thumbnail,
                        'cart_item_key' => $cart_item_key,
                        'quantity'		=> $cart_item['quantity'],
                        'variation'		=> $variation
                        //'max_quantity' => $max_quantity
                    );
                $json[] = $item_data_array;
			}
        }


        /**
		 * ENDPOINT - Remove a single cart item
		 * @return success or error
		 *-------------------------------------------- */
		if ( $_POST['endpoint'] == 'remove_cart_item' ) {
			$cart_item_key = $_POST['hash'];

			// Check if the item exist in the cart
        	if( !isset( WC()->cart->get_cart()[ $cart_item_key ] ) ) {
        		$json[] = "Unable to remove this item at the moment.";
        		$error = true;
        	} 

        	if ( $error === false ) {
				WC()->cart->set_quantity( $cart_item_key, 0, false );
				WC()->cart->calculate_totals();

				$json['success'] = 1;
				$json['remaining_items'] = WC()->cart->get_cart_contents_count();
        	}
        } 


        /**
		 * ENDPOINT - Empty cart
		 * @return success or error
		 *-------------------------------------------- */
        if ( $_POST['endpoint'] == 'empty_cart' ) {
        	if ( WC()->cart->get_cart_contents_count() == 0 ) {
        		$json[] = "Your cart is already empty.";
		    } else {
		    	WC()->cart->empty_cart();
		    	$json['success'] = 1;
		    }
        }


        /**
		 * ENDPOINT - Update cart item quantity
		 * @return success or error
		 *-------------------------------------------- */
        if ( $_POST['endpoint'] == 'update_cart_item' ) {
        	// Check for quantity and hash
		    if ( !isset( $_POST['hash'] ) || !isset( $_POST['quantity'] ) ) {
		    	$json[] = "Please enter the item quantity.";
        		$error = true;
		    }

		    $cart_item_key = $_POST['hash'];

		    if ( !isset( WC()->cart->get_cart()[ $cart_item_key ] ) ) {
		    	$json[] = "Unable to update this item quantity.";
        		$error = true;
		    }

		    $values = WC()->cart->get_cart()[ $cart_item_key ];
			$_product = $values['data'];
			$quantity = apply_filters( 'woocommerce_stock_amount_cart_item', apply_filters( 'woocommerce_stock_amount', preg_replace( "/[^0-9\.]/", '', filter_var($_POST['quantity'], FILTER_SANITIZE_NUMBER_INT)) ), $cart_item_key );

		    if ( '' === $quantity || $quantity == $values['quantity'] ) {
		    	$json[] = "Unable to update this item quantity.";
        		$error = true;
		    }

		    // Update cart validation
			$passed_validation = apply_filters( 'woocommerce_update_cart_validation', true, $cart_item_key, $values, $quantity );
			$max_purchase = $_product->backorders_allowed() ? '' : $_product->get_stock_quantity();

		    // is_sold_individually
		    if ( $_product->is_sold_individually() && $quantity > 1 ) {
		    	$json[] =  sprintf( 'You can only have <strong>1 %s</strong> in your cart.', $_product->get_title() );
		        $passed_validation = false;
		        $error = true;
		    }

		    // check max purchase
		    else if ( $max_purchase != NULL && $quantity > $max_purchase ) {
				$json[] = sprintf('You can only purchase %s of this item.', $max_purchase );
		        $passed_validation = false;
		        $error = true;
		    }

		    if ( $passed_validation || $error == false ) {
		    	WC()->cart->set_quantity( $cart_item_key, $quantity, false );
				WC()->cart->calculate_totals();

		        $json['success'] = 1;
		    }
		}

		// Close the function
        echo json_encode( $json );
        die();
	}


	/**
	 * Products Ajax Call
	 * Connect to WooComerce API to retrieve product data
	 *---------------------------------------------------- */
	public function dtcmc_action_product_ajax() {
		
		// Security Checks
		/*if ( ! isset( $_POST['security'] ) || !wp_verify_nonce($_POST['security'], 'dtcmc_product_nonce') )
			die();*/

		include_once( $this->plugin_path . 'init.php' );
		$json = array();


		/**
		 * ENDPOINT - Get a specific product by ID
		 * @return API product data
		 * @return WC variation data
		 * @return WC arttibute data
		 *-------------------------------------------- */
		if ( $_POST['endpoint'] == 'get_product' ) {
			$product = wc_get_product( $_POST['product_id'] );

        	$product_data = $woocommerce->get( 'products/'.$_POST['product_id'] );

        	// Add additional information
        	if ( $product->enable_dimensions_display() ) {
	        	$dimensions_data = array();

	        	$weight = wc_format_localized_decimal( $product->get_weight() );
	        	if ( $weight ) {
	        		$weight = $weight.' '.esc_attr( get_option( 'woocommerce_weight_unit' ) );

		        	$dimensions_data[] = array(
		        		'name' => 'Weight',
		        		'value' => $weight
		        	);
	        	}

	        	if ( $product->has_dimensions() ) {
		        	$dimensions_data[] = array(
		        		'name' => 'Dimensions',
		        		'value' => $product->get_dimensions()
		        	);
	        	}
	        	
	        	$product_data['product']['dimensions_data'] = $dimensions_data;
	        }


        	// Edit group product child titles
        	if ( $product_data['product']['type'] == 'grouped' ) {
	        	foreach( $product_data['product']['grouped_products'] as &$value ) {
	        		$rename_title = explode('&rarr; ', $value['title']);
					$value['title'] = $rename_title[1];
				}
			}

        	$json['product'] = $product_data['product'];

        	// Is this a variable product
        	if ( $product->is_type( 'variable' ) ) {
        		$get_variations = sizeof( $product->get_children() ) <= apply_filters( 'woocommerce_ajax_variation_threshold', 30, $product );
				$available_variations = $get_variations ? $product->get_available_variations() : false;
        		$attributes_data = $product->get_variation_attributes();

        		// Re-create the attribute to make it easier for angular
        		$attributes = array();
				foreach ( $attributes_data as $item => $value ) {
        			$name = wc_attribute_label( $item );
					$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $item ) ] ) ? wc_clean( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $item ) ] ) ) : $product->get_variation_default_attribute( $item );

					$attributes[] = array(
        				'name' =>  $name,
        				'slug' => 'attribute_'.sanitize_title( $item ),
        				'options' => $value,
        				'selected' => $selected
					);
        		}
        		$json['variations'] = $available_variations;
        		$json['attributes'] = $attributes;
        	}
		}


		/**
		 * ENDPOINT - Get all Products
		 * @return API product data
		 *-------------------------------------------- */
		if ( $_POST['endpoint'] == 'get_all_products' ) {
        	// Remove none API data
        	unset($_POST['action']);
			unset($_POST['security']);
			unset($_POST['endpoint']);

			$results = $woocommerce->get( 'products', $_POST );
			
			// Remove products that are set to hidden
			foreach( $results['products'] as $sub_key => $sub_array ){
				if( $sub_array['catalog_visibility'] == "hidden" ){
				   unset( $results['products'][$sub_key] );
				}
			}

			foreach ( $results['products'] as &$value ) {
				// Format the single price
				$value['price_formated'] = wc_price( $value['price'] );

				// Edit group product child titles
				if ( $value['parent_id'] != 0 ) {
					$rename_title = explode('&rarr; ', $value['title']);
					$value['title'] = $rename_title[1];
				}
			}

			$json = $results['products'];
		}

		echo json_encode( $json );
		die();
	}

	/**
	 * Authentications Calls
	 * Handles all users auth calls
	 *-------------------------------------------- */
	public function dtcmc_action_auth_ajax() {
		// Security Checks
		if ( ! isset( $_POST['security'] ) || !wp_verify_nonce($_POST['security'], 'dtcmc_auth_nonce') )
			die('Permission Denied');

        $json = array();
        $error = false;

        /**
		 * ENDPOINT - Login a user
		 * @return success or error
		 *-------------------------------------------- */
        if ( $_POST['endpoint'] == 'login' ) {
	        global $wpdb;

			// Escape all inputs to avoid SQL injection.
		    $username = $wpdb->escape( trim($_POST['username']) );
		    $password = $wpdb->escape( trim($_POST['password']) );

		    // Set redirection url
		    $redirection_url = get_permalink( get_option('woocommerce_myaccount_page_id') );
		    if ( $_POST['redirect'] == 'checkout' ) {
		    	$redirection_url = wc_get_checkout_url();
		    }
	    	
	    	// Validate
		    if( empty( $username ) ) {
		        $json[] = 'The username field is required.';
		    } else if( empty( $password ) ) {
		        $json[] = 'The password field is required.';
		    } else {
	        
		        $user_data = array();
		        $user_data['user_login'] = $username;
		        $user_data['user_password'] = $password;
		        $user_data['remember'] = 'forever';  
		        $user = wp_signon( $user_data, false );
		        
		        if ( is_wp_error($user) ) {
		        	// Check for errors
					$error_code = $user->get_error_codes();
					
					if ( in_array( 'invalid_username', $error_code ) ) {
						$json[] = 'This username is invalid.';
					}

					if ( in_array( 'incorrect_password', $error_code ) ) {
						$json[] = 'The password you entered is incorrect.';
					}
		        } else {
		            wp_set_current_user( $user->ID, $username );
		        	do_action('set_current_user');
		            
		            $json['success'] = 1;
		            $json['redirection_url'] = $redirection_url;
		        }
		    }
		}


        /**
		 * ENDPOINT - Register a user
		 * @return success or error
		 *-------------------------------------------- */
        if ( $_POST['endpoint'] == 'register' ) {
			global $wpdb;
			$json = array();

			// Escape all inputs to avoid SQL injection.
			$username = $wpdb->escape( trim($_POST['username']) );
			$email = $wpdb->escape( trim($_POST['email']) );
			$password = $wpdb->escape( trim($_POST['password']) );

			// Set redirection url
		    $redirection_url = get_permalink( get_option('woocommerce_myaccount_page_id') );
		    if ( $_POST['redirect'] == 'checkout' ) {
		    	$redirection_url = wc_get_checkout_url();
		    }
	    	
			// Check password length
			if ( strlen($password) < 7 ) {
				$json[] = "The password should be at least seven characters long.";
			} else {

				$do_register = wc_create_new_customer( $email, $username, $password );

				if ( is_wp_error($do_register) ) {
					$json[] = $do_register->get_error_message();
				} else {
					// Auto login the user
					wc_set_customer_auth_cookie( $do_register );

					$json['success'] = 1;
					$json['redirection_url'] = $redirection_url;
				}
			}
		}

		// Close the function
        echo json_encode( $json );
        die();
	}

}
?>