(function() {  "use strict";
  jQuery(function($) {
    var $csv_data, $export, $offset, $process, $status, calculate_product_valuation;
    $offset = 0;
    $status = 'pending';
    $csv_data = "data:application/csv;charset=utf-8,Product,Parent,Value at Retail,Value at Cost,Units in stock,Stock status\n";
    $export = $('.export_product_valuation_csv');
    $process = $('.wc-cog-product-valuation-progress');
    calculate_product_valuation = function() {
      return $.ajax({
        type: 'POST',
        url: ajaxurl,
        data: {
          action: 'wc_cog_do_ajax_product_valuation',
          offset: $offset,
          status: $status,
          security: wc_cog_product_valuation.product_valuation_nonce
        },
        dataType: 'json',
        success: function(response) {
          var $product_data;
          if (response.success) {
            $offset = response.data.offset;
            $status = response.data.status;
            $product_data = response.data.product_data;
            if ('' !== $product_data) {
              $csv_data += $product_data + "\n";
            }
            $('.wc-cog-progress').val(response.data.percentage);
            if ('done' === $status) {
              return setTimeout(function() {
                var $link;
                $export.removeClass('hide');
                $process.addClass('hide').removeClass('show');
                $link = document.createElement('a');
                $link.download = $export.data('filename');
                $link.href = encodeURI($csv_data);
                document.body.appendChild($link);
                $link.click();
                return document.body.removeChild($link);
              }, 500);
            } else {
              return calculate_product_valuation();
            }
          }
        }
      });
    };
    return $export.on('click', function(e) {
      e.preventDefault();
      $export.addClass('hide');
      $process.removeClass('hide').addClass('show');
      return calculate_product_valuation();
    });
  });

}).call(this);


