var isAndroid = Framework7.prototype.device.android === true;
var isIos = Framework7.prototype.device.ios === true;

var MyApp = {};

// Initialize Angular
MyApp.angular = angular.module('dtcwmApp', ['dtcwmApp.controllers', 'dtcwmApp.services', 'ngStorage']);

MyApp.angular.run(function($rootScope){
    $rootScope.deviceAndroid = isAndroid;
    $rootScope.deviceIos = isIos;
})

// Initialize Framework7
MyApp.fw7 = {
	app : new Framework7({
		material: isIos ? false : true,
		domCache: true,
		swipePanel: 'left',
		notificationCloseButtonText: 'Ok',
		notificationHold: 3000,
		swipeBackPage: false,
		animateNavBackIcon: true,
		hideNavbarOnPageScroll: true,
		hideToolbarOnPageScroll: true,
		scrollTopOnNavbarClick: true,
		fastClicks: false,
		pushState: true,
		pushStateSeparator: '',
		pushStateRoot: dtcwm_vars.siteURL+'/',
	}),
	options : {
		domCache: true
	},
	views : []
};

// Configuration Variables
MyApp.config = {
	productPerPage: 8,
	cartAction: 'dtcmc_action_cart',
	productAction: 'dtcmc_action_product',
	authAction: 'dtcmc_action_auth'
};

var $$ = Dom7;

var progressContainer = $$('body');