angular.module('dtcwmApp.controllers', [])

/**
 * Controller - Main
 * - Use for master controller
 *-------------------------------------------- */
.controller('MainCtrl', ['$scope', 'InitApp', 'customData', '$localStorage', function($scope, InitApp, customData, $localStorage) {
    
    // Set local storage defaults
    $scope.$storage = $localStorage.$default({
        cartTotal: 0,
        catalogLayout: 'list',
        categoryData: '',
        productView: ''
    });

    // Watch for cart total changes
    $scope.$watch(function() {
        return angular.toJson($localStorage);
    }, function() {
        // console.log($localStorage);

        $scope.cartTotalShow = $localStorage.cartTotal;
        if ( $localStorage.cartTotal > 99 ) {
            $scope.cartTotalShow = '99+';
        }
    });

    InitApp.addEventListener('ready', function () {
        if (progressContainer.children('.progressbar, .progressbar-infinite').length) return;
    
        // Input focus fix
        flagClearClicked = false;
        eventNameForFocus = "focus";
        // eventNameForFocus = "touchstart focus";

        //$$(document).on("focus","textarea", function(e){
        $$(document).on(eventNameForFocus,".kbdfix", function(e){
            flagClearClicked = false;
            var el = $$(e.target);
            var page = el.closest(".page-content");
            var elTop = el.offset().top;
            //do correction if input at near or below middle of screen
            if(elTop > page.height() / 2 - 20 ){
                var delta = page.offset().top +  elTop - $$(".statusbar-overlay").height() * (Framework7.prototype.device.ios?2:1) - $$(".navbar").height(); //minus navbar height?&quest;? 56 fot MD 
                var kbdfix = page.find("#keyboard-fix");
                if(kbdfix.length == 0) { //create kbdfix element
                    page.append("<div id='keyboard-fix'></div>");
                }

                $$("#keyboard-fix").css("height", delta * 2 + "px");
                page.scrollTop( delta, 300);
                //try to return caret to input field
                //dirty hack ios flying caret
                if(Framework7.prototype.device.ios) {
                    setTimeout(function () {

                        var temp = $$(el).val();
                        if(temp !=="") {
                            $$(el).val("");
                            $$(el).val(temp);
                        } else {
                            $$(el).val(" ");
                            $$(el).val("");
                        }
                        el.focus();
                        //el[0].select(); // apply focus or select to return caret to input field
                    }, 700); //set by experemtal on iPod
                }

                e.preventDefault();
                e.stopImmediatePropagation();
            }

        }, true);

        //$$(document).on("blur","input,textarea", function(e){
        //call this code in the Back button handler - when it fired for keyboard hidding.
        $$(document).on("blur",".kbdfix", function(e){
            // console.log("blur");
            //reduce all fixes
            if(!flagClearClicked) {
                setTimeout(function() {
                    $$("#keyboard-fix").css("height", "0px");
                    flagClearClicked = false;
                },400);

            }
        }, true);

        // Disable GO button on keypad for specific form inputs
        $$('.hide-keypad input').keypress(function(e){
            if ( e.which == 13 ) {
                $$(this).blur();
                e.preventDefault();
            }
        });

        // Show loader on every external link click
        /*$$('.external').on('click', function () {
            MyApp.fw7.app.showProgressbar(progressContainer, 'multi');
        });*/

        // Logout even callback
        $scope.authLogout = function() {
            $localStorage.cartTotal = 0;
        }

        // Login Authentication
        $scope.loginData = {};
        $scope.authLogin = function() {
            MyApp.fw7.app.showProgressbar(progressContainer, 'multi');
            
            var postData = {
                action: MyApp.config.authAction,
                endpoint: 'login',
                security: dtcwm_vars.dtcwm_auth_nonce
            };

            // Merge form and CTRL data
            var postDataMerge = Object.assign(this.loginData, postData);

            customData.post( postDataMerge ).then(function(response) {
                MyApp.fw7.app.hideProgressbar();
                //console.log(response);

                // If failed show error
                if ( response.success != 1 ) {
                    MyApp.fw7.app.addNotification({
                        title: 'Error!',
                        message: response
                    });
                    return;
                }

                MyApp.fw7.app.addNotification({
                    title: 'Login was successful!',
                    message: 'Redirecting you, please wait...'
                });
                window.location = ''+ response.redirection_url +'';

            }, function(error) {
                MyApp.fw7.app.hideProgressbar();
                //console.log(error);

                MyApp.fw7.app.addNotification({
                    title: 'Oh Snap!',
                    message: 'Something went wrong, we are unable to fulfill your request at the moment.'
                });
            })
        }

        // Register Authentication
        $scope.registerData = {};
        $scope.authRegister = function() {
            MyApp.fw7.app.showProgressbar(progressContainer, 'multi');
            
            var postData = {
                action: MyApp.config.authAction,
                endpoint: 'register',
                security: dtcwm_vars.dtcwm_auth_nonce
            };

            // Merge form and CTRL data
            var postDataMerge = Object.assign(this.registerData, postData);

            customData.post( postDataMerge ).then(function(response) {
                MyApp.fw7.app.hideProgressbar();
                //console.log(response);

                // If failed show error
                if ( response.success != 1 ) {
                    MyApp.fw7.app.addNotification({
                        title: 'Error!',
                        message: response
                    });
                    return;
                }

                MyApp.fw7.app.addNotification({
                    title: 'Registration was successful!',
                    message: 'Redirecting you, please wait...'
                });
                window.location = ''+ response.redirection_url +'';

            }, function(error) {
                MyApp.fw7.app.hideProgressbar();
                //console.log(error);

                MyApp.fw7.app.addNotification({
                    title: 'Oh Snap!',
                    message: 'Something went wrong, we are unable to fulfill your request at the moment.'
                });
            })
        }

    });
}])


/**
 * Home Controller
 *-------------------------------------------- */
.controller('HomeCtrl', ['$scope', '$localStorage', function($scope, $localStorage) {
    
    // Store category to view data in localstorage
    $scope.setCategory = function( nameData, slugData ) {
        $localStorage.categoryData = {name: nameData, slug: slugData};
    }
}])


/**
 * Categories Controller
 *-------------------------------------------- */
.controller('CategoryCtrl', ['$scope', '$localStorage', function($scope, $localStorage) {
    MyApp.fw7.app.onPageInit('category', function () {
        // Store category to view data in localstorage
        $scope.setCategory = function( nameData, slugData ) {
            $localStorage.categoryData = {name: nameData, slug: slugData};
        }
    });
}])


/**
 * Controller - Catalog view
 * - Get all products based on category
 * - Infinite Scroll
 * - Pull to refresh
 *-------------------------------------------- */
.controller('CatalogCtrl', ['$scope', 'customData', '$localStorage', function($scope, customData, $localStorage) {
    // Page init
    var initLoad = MyApp.fw7.app.onPageInit('catalog', function () {

        $scope.categoryName = $localStorage.categoryData.name ? $localStorage.categoryData.name : 'Browse';
        $scope.products = false;
            
        var postData = {
            action: MyApp.config.productAction,
            endpoint: 'get_all_products',
            security: dtcwm_vars.dtcwm_product_nonce,
            'filter[category]': $localStorage.categoryData.slug,
            'filter[limit]': MyApp.config.productPerPage
        };

        MyApp.fw7.app.detachInfiniteScroll($$('#page-catalog .infinite-scroll'));
        $$('#page-catalog .infinite-scroll-preloader').hide();
        
        $$('#page-catalog .content-loader').addClass('blank-state');
        $$('#page-catalog .not-found').removeClass('blank-state');
        $$('#page-catalog .error-response').removeClass('blank-state');

        customData.post( postData ).then(function(response) {
            // console.log(response);
            $$('#page-catalog .content-loader').removeClass('blank-state');  
            
            // Did we get back result?
            if ( response.length <= 0 ) {
                MyApp.fw7.app.detachInfiniteScroll($$('#page-catalog .infinite-scroll'));
                $$('#page-catalog .not-found').addClass('blank-state');
                return;
            }

            MyApp.fw7.app.attachInfiniteScroll($$('#page-catalog .infinite-scroll'));
            $scope.products = response;
        }, function(error) {
            // console.log(error);

            MyApp.fw7.app.detachInfiniteScroll($$('#page-catalog .infinite-scroll'));
            $$('#page-catalog .error-response').addClass('blank-state');
            $$('#page-catalog .content-loader').removeClass('blank-state');
        })
    });

    // Page Re-init
    MyApp.fw7.app.onPageReinit('catalog', function () {
        initLoad.trigger();
    });

    // Infinite scroll
    pagination = 2;
    var loading = false;
    $scope.loadMore = function () {
        if (loading) return;
        
        loading = true;
        var page = pagination++;

        $$('#page-catalog .infinite-scroll-preloader').show();
        setTimeout(function () {
            loading = false;

            var postData = {
                action: MyApp.config.productAction,
                endpoint: 'get_all_products',
                security: dtcwm_vars.dtcwm_product_nonce,
                'filter[category]': $localStorage.categoryData.slug,
                'filter[limit]': MyApp.config.productPerPage,
                'page': page
            };

            customData.post( postData ).then(function(response) {
                // console.log(response);
                $$('#page-catalog .infinite-scroll-preloader').hide();
            
                // Did we get back result?
                if ( response.length <= 0 ) {
                    MyApp.fw7.app.detachInfiniteScroll($$('#page-catalog .infinite-scroll'));

                    MyApp.fw7.app.addNotification({
                        title: 'Heads Up!',
                        message: 'No more products.'
                    });
                    return;
                }

                angular.forEach(response, function(value, key) {
                    $scope.products.push(value);
                });

            }, function(error) {
                // console.log(error);
                MyApp.fw7.app.detachInfiniteScroll($$('#page-catalog .infinite-scroll'));
                $$('#page-catalog .infinite-scroll-preloader').hide();

                MyApp.fw7.app.addNotification({
                    title: 'Oh Snap!',
                    message: 'Something went wrong, pull to refresh.'
                });
            })
        }, 1000);
    }

    // Call Infinite
    $$('#page-catalog .infinite-scroll').on('infinite', function () {
        $scope.loadMore();
    });

    // Pull to refresh content
    var pullTrigger = $$('#page-catalog .pull-to-refresh-content');
    pullTrigger.on('refresh', function() {
        pagination = 2;

        initLoad.trigger();
        MyApp.fw7.app.pullToRefreshDone();
    });
}])


/**
 * Controller - Viewing single product
 * - Get the product data
 * - Add the product to cart
 * - Show product images in gallery
 *-------------------------------------------- */
.controller('ViewProductCtrl', ['$scope', 'customData', '$localStorage', function($scope, customData, $localStorage) {
    if (progressContainer.children('.progressbar, .progressbar-infinite').length) return;

    // Page init
    var initLoad = MyApp.fw7.app.onPageInit('view-product', function () {

        $$('#page-view-product .content-loader').addClass('blank-state');

        // Set some vars
        $scope.productID = $localStorage.productView;
        $scope.data = false;

        // HTTP Params
        var postData = {
            action: MyApp.config.productAction,
            endpoint: 'get_product',
            security: dtcwm_vars.dtcwm_product_nonce,
            product_id: $scope.productID
        };

        // Get the product data
        customData.post( postData ).then(function(response) {
            // console.log(response);
            $$('#page-view-product .content-loader').removeClass('blank-state');  
            
            // Did we get back results?
            if ( response.length <= 0 ) {
                $$('#page-view-product .not-found').addClass('blank-state');
                return;
            }

            // Set scope product data
            $scope.data = {
                'product': response.product,
                'variations': response.variations,
                'attributes': response.attributes
            };

            // Wait until items are added to the DOM
            setTimeout(function() {
                // Init image slider
                MyApp.fw7.app.swiper('#page-view-product .swiper-container', {
                    autoHeight: true,
                    spaceBetween: 10,
                    loop: true,
                    pagination: '.swiper-pagination'
                });

                // Init numpad for single product
                var numpadInput = MyApp.fw7.app.keypad({
                    input: '#product-'+$scope.data.product.id+'',
                    dotButton: false,
                });

                // Init numpad for Group products
                if ( $scope.data.product.type == 'grouped') {
                    for (var i = 0, len = $scope.data.product.grouped_products.length; i < len; i++) {
                        var singleItems = $scope.data.product.grouped_products[i];

                        var numpadInput = MyApp.fw7.app.keypad({
                            input: '#product-'+singleItems.id+'',
                            dotButton: false,
                        });
                    }
                }

            }, 10);
        }, function(error) {
            // console.log(error);

            MyApp.fw7.app.addNotification({
                title: 'Oh Snap!',
                message: 'Something went wrong, we are unable to fulfill your request at the moment.'
            });
        })

    });

    // Page Re-init
    MyApp.fw7.app.onPageReinit('view-product', function () {
        initLoad.trigger();
    });
   
    // Validate the variation selections
    $scope.variationSelect = function() {
        var matching_variations = variation_matcher.find_matching_variations( $scope.data.variations, this.orderData.variation );
        var variation = matching_variations.shift();

        // is the variation available?
        if ( ! variation ) {
            $$('.product-price').html('<strong style="color:#f44336;text-transform:uppercase;font-size:13px;">Unavailable</strong>');
            document.orderForm.addCart.setAttribute("disabled",'disabled');
            document.orderForm.quantity.setAttribute("disabled",'disabled');

            MyApp.fw7.app.addNotification({
                title: 'Error!',
                message: 'Sorry, this combination is unavailable.'
            });
            return;
        }

        // is the variation price set?
        if ( variation.display_price == 0 ) {
            $$('.product-price').html('<strong style="color:#f44336;text-transform:uppercase;font-size:13px;">Unavailable</strong>');
            document.orderForm.addCart.setAttribute("disabled",'disabled');
            document.orderForm.quantity.setAttribute("disabled",'disabled');

            MyApp.fw7.app.addNotification({
                title: 'Error!',
                message: 'Sorry, this combination is unavailable.'
            });
            return;
        }

        // is the variation out of stock?
        if ( variation.is_in_stock == false ) {
            $$('.product-price').html('<strong style="color:#f44336;text-transform:uppercase;font-size:13px;">Out of stock</strong>');
            document.orderForm.addCart.setAttribute("disabled",'disabled');
            document.orderForm.quantity.setAttribute("disabled",'disabled');

            MyApp.fw7.app.addNotification({
                title: 'Error!',
                message: 'Sorry, this combination is out of stock.'
            });
            return;
        }

        // Set some other vars
        document.orderForm.addCart.removeAttribute('disabled');
        document.orderForm.quantity.removeAttribute('disabled');
        $$('.product-price').html(variation.price_html);
        $scope.variationID = variation.variation_id;
    }

    // Add product to cart
    $scope.orderData = {};
    $scope.addToCart = function() {
        MyApp.fw7.app.showProgressbar(progressContainer, 'multi');

        // Validate pre-selected variation
        if ( $scope.data.product.type == 'variable' ) {
            $scope.variationSelect();
        }

        // Ensure quantity is not less than 1
        if ( this.orderData.quantity <= 0) {
            MyApp.fw7.app.addNotification({
                title: 'Error!',
                message: 'The quantity field cannot be less than 1.'
            });
            MyApp.fw7.app.hideProgressbar();
            return;
        }

        var postData = {
            action: MyApp.config.cartAction,
            security: dtcwm_vars.dtcwm_cart_nonce,
            endpoint: 'add_cart_item',
            product_id: $scope.productID,
            variation_id: $scope.variationID ? $scope.variationID : 0,
            type: $scope.data.product.type
        };

        // Merge form and CTRL data
        var postDataMerge = Object.assign(this.orderData, postData);

        customData.post( postDataMerge ).then(function(response) {
            // console.log(response);
            MyApp.fw7.app.hideProgressbar();

            if ( response.success == 1 ) {
                // Show success modal
                MyApp.fw7.app.modal({
                    title: 'Product Added!',
                    text: 'This item was successfully added to your cart.',
                    buttons: [
                    {
                        text: 'View Cart',
                        onClick: function () {
                            $$('#cart-link').click();
                        }
                    },
                        {
                            text: 'Continue',
                            bold: true
                        }
                    ]
                })

                // Update cart total in local storage
                $localStorage.cartTotal = response.total_items;
            } else {
                MyApp.fw7.app.addNotification({
                    title: 'Error',
                    message: response
                });
            }
        }, function(error) {
            MyApp.fw7.app.hideProgressbar();
            MyApp.fw7.app.addNotification({
                title: 'Oh Snap!',
                message: 'Something went wrong, we are unable to fulfill your request at the moment.'
            });
        })
    }

    // Search through the variation data for a match
    var variation_matcher = {
        find_matching_variations: function( product_variations, settings ) {
            var matching = [];
            for ( var i = 0; i < product_variations.length; i++ ) {
                var variation    = product_variations[i];

                if ( variation_matcher.variations_match( variation.attributes, settings ) ) {
                    matching.push( variation );
                }
            }
            return matching;
        },
        variations_match: function( attrs1, attrs2 ) {
            var match = true;
            for ( var attr_name in attrs1 ) {
                if ( attrs1.hasOwnProperty( attr_name ) ) {
                    var val1 = attrs1[ attr_name ];
                    var val2 = attrs2[ attr_name ];
                    if ( val1 !== undefined && val2 !== undefined && val1.length !== 0 && val2.length !== 0 && val1 !== val2 ) {
                        match = false;
                    }
                }
            }
            return match;
        }
    };

    // Image gallery
    $scope.viewGallery = function(images) {
        var imageArray = [];

        for (var i in images){
            imageArray.push( images[i]["src"] );
        }

        var showImages = MyApp.fw7.app.photoBrowser({
            photos: imageArray,
            theme: 'dark',
            lazyLoading: true,
            toolbarTemplate: "<div class='toolbar tabbar'><div class='toolbar-inner'><a href='#' class='ajax link photo-browser-prev'><i class='icon wm-photo-browser-prev'></i></a><a href='#' class='ajax link photo-browser-next'><i class='icon wm-photo-browser-next'></i></a></div></div>",
            navbarTemplate: "<div class='navbar'><div class='navbar-inner'><div class='center sliding'><span class='photo-browser-current'></span><span class='photo-browser-of'>{{ofText}}</span><span class='photo-browser-total'></span></div><div class='right sliding'><a href='#' class='ajax link close-popup photo-browser-close-link {{#unless backLinkText}}icon-only{{/unless}}'><i class='icon wm-ios-close-circle'></i></a></div></div></div>"
        });

        showImages.open();
    }
}])


/**
 * Controller - Product Search
 * - Get all products based on query
 * - Infinite Scroll
 *-------------------------------------------- */
.controller('SearchCtrl', ['$scope', 'customData', function($scope, customData) {
    MyApp.fw7.app.onPageInit('search', function () {
 
        $scope.search = function() {
            $scope.products = false;
            pagination = 2;
            $$('#page-search .not-found').removeClass('blank-state');
            $$('#page-search .error-response').removeClass('blank-state');

            doSearch( $scope.query );
        }

        function doSearch(query) {
            // Check if the query is empty
            if ( query == "" ) {
                $$('#page-search .empty-msg').attr('style', 'display: flex;');
                return;
            }

            var postData = {
                action: MyApp.config.productAction,
                endpoint: 'get_all_products',
                security: dtcwm_vars.dtcwm_product_nonce,
                'filter[q]': query,
                'filter[limit]': MyApp.config.productPerPage
            };

            $$('#page-search .empty-msg').hide();
            $$('#page-search .content-loader').addClass('blank-state');

            // Get Products
            customData.post( postData ).then(function(response) {
                // console.log(response);
                $$('#page-search .content-loader').removeClass('blank-state');  
                
                // Did we get back result?
                if ( response.length <= 0 ) {
                    $$('#page-search .not-found').addClass('blank-state');
                    return;
                }

                MyApp.fw7.app.attachInfiniteScroll($$('#page-search .infinite-scroll'));
                $scope.products = response;
            }, function(error) {
                // console.log(error);
                $$('#page-search .content-loader').removeClass('blank-state');
                $$('#page-search .error-response').addClass('blank-state');
            })
        }
    })

    // Infinite scroll
    var loading = false;
    $scope.loadMore = function () {
        if (loading) return;
        
        loading = true;
        var page = pagination++;

        $$('#page-search .infinite-scroll-preloader').show();
        setTimeout(function () {
            loading = false;

            var postData = {
                action: MyApp.config.productAction,
                endpoint: 'get_all_products',
                security: dtcwm_vars.dtcwm_product_nonce,
                'filter[q]': $scope.query,
                'filter[limit]': MyApp.config.productPerPage,
                'page': page
            };

            customData.post( postData ).then(function(response) {
                // console.log(response);
                $$('#page-search .infinite-scroll-preloader').hide();
            
                // Did we get back result?
                if ( response.length <= 0 ) {
                    MyApp.fw7.app.detachInfiniteScroll($$('#page-search .infinite-scroll'));

                    MyApp.fw7.app.addNotification({
                        title: 'Heads Up!',
                        message: 'No more products.'
                    });
                    return;
                }

                angular.forEach(response, function(value, key) {
                    $scope.products.push(value);
                });

            }, function(error) {
                // console.log(error);
                MyApp.fw7.app.detachInfiniteScroll($$('#page-search .infinite-scroll'));
                $$('#page-search .infinite-scroll-preloader').hide();

                MyApp.fw7.app.addNotification({
                    title: 'Oh Snap!',
                    message: 'Something went wrong, pull to refresh.'
                });
            })
        }, 1000);
    }

    // Call Infinite
    $$('#page-search .infinite-scroll').on('infinite', function () {
        $scope.loadMore();
    });
}])


/**
 * Controller - Shopping Cart
 * - Get cart items
 * - Update item quantities
 * - Remove items from cart
 * - Empty the cart
 * - Pull to refresh to refresh the cart items
 *-------------------------------------------- */
.controller('CartCtrl', ['$scope', 'customData', '$localStorage', function($scope, customData, $localStorage) {
    if (progressContainer.children('.progressbar, .progressbar-infinite').length) return;

    // Page init
    var initLoad = MyApp.fw7.app.onPageInit('cart', function () {
        function getCartItems() {
            $$('#page-cart .error-response').removeClass('blank-state');
            $$('#page-cart .not-found').removeClass('blank-state');
            $$('#page-cart .content-loader').addClass('blank-state');

            customData.post( {action: MyApp.config.cartAction, endpoint: 'get_cart_items', security: dtcwm_vars.dtcwm_cart_nonce} ).then(function(response) {
                // console.log(response);
                $$('#page-cart .content-loader').removeClass('blank-state');  
                
                // Return if there is no data
                if ( response.length <= 0 ) {
                    $$('#page-cart .not-found').addClass('blank-state');
                    return;
                }

                $scope.cartItems = response;
                $scope.getCartTotals();
                
                // Wait until cart items are added to the DOM
                setTimeout(function(){
                    // Initiate swiper slider
                    if ($$(".cart-items-swipe")[0]) {
                        var cartSwiper = MyApp.fw7.app.swiper('.cart-items-swipe .swiper-container', {
                            effect: "coverflow",
                            autoHeight: "true",
                            slidesPerView: "auto",
                            centeredSlides: "true"
                        });
                    }    
                },10);
            }, function(error) {
                // console.log(error);
                $$('#page-cart .error-response').addClass('blank-state');
                $$('#page-cart .content-loader').removeClass('blank-state');
            })
        } getCartItems();
    });

    // Page Re-init
    MyApp.fw7.app.onPageReinit('cart', function () {
        // Clear old data
        $scope.cartItems = false;
        $scope.cartTotals = false;

        initLoad.trigger();
    });

    // Update item quantity
    $scope.updateQuantity = function( inputID, cart_item_key ) {
        var numpadInput = MyApp.fw7.app.keypad({
            
            input: '#product-'+inputID+'',
            dotButton: false,
            onClose: function (p) {
                // Validate quantity field
                if ( !p.value ) {
                    return;
                }

                // Ensure quantity is not less than 1
                if ( p.value <= 0) {
                    MyApp.fw7.app.addNotification({
                        title: 'Error!',
                        message: 'The quantity field cannot be less than 1.'
                    });
                    MyApp.fw7.app.hideProgressbar();
                    return;
                }

                MyApp.fw7.app.showProgressbar(progressContainer, 'multi');

                var postData = {
                    action: MyApp.config.cartAction,
                    endpoint: 'update_cart_item',
                    quantity: p.value,
                    security: dtcwm_vars.dtcwm_cart_nonce,
                    hash: cart_item_key
                };

                customData.post( postData ).then(function(response) {
                    MyApp.fw7.app.hideProgressbar();
                    //console.log(response);

                    if ( response.success == 1 ) {
                        // Clear old data
                        $scope.cartItems = false;
                        $scope.cartTotals = false;
                        initLoad.trigger();

                        MyApp.fw7.app.addNotification({
                            title: 'Cart Updated!',
                            message: 'Your cart was successfully updated.'
                        });
                    } else {
                        MyApp.fw7.app.addNotification({
                            title: 'Error!',
                            message: response
                        });
                    }
                }, function(error) {
                    MyApp.fw7.app.hideProgressbar();
                    //console.log(error);

                    MyApp.fw7.app.addNotification({
                        title: 'Oh Snap!',
                        message: 'Something went wrong, we are unable to fulfill your request at the moment.'
                    });
                })
            }
        });

        // delay input open
        setTimeout(function(){
            numpadInput.open();
        },10);
        
    }

    // Get cart totals
    $scope.getCartTotals = function() {
        customData.post( {action: MyApp.config.cartAction, endpoint: 'get_cart_totals', security: dtcwm_vars.dtcwm_cart_nonce} ).then(function(response) {
            // console.log(response);
            $scope.cartTotals = response;

            // Update cart total in local storage
            if ( response.total_items != $localStorage.cartTotal ) {
                $localStorage.cartTotal = response.total_items;
            }
        })
    }

    // Remove an item
    $scope.removeItem = function( cart_item_key ) {
        MyApp.fw7.app.confirm('Are you sure about removing this item?', 'Remove Item',function () {
            
            customData.post( {action: MyApp.config.cartAction, endpoint: 'remove_cart_item', security: dtcwm_vars.dtcwm_cart_nonce, hash: cart_item_key} ).then(function(response) {
                // console.log(response);

                if ( response.success == 1 ) {
                    
                    // Check if the cart is empty
                    if ( response.remaining_items == 0 ) {
                        $localStorage.cartTotal = 0; // update cart totals

                        $scope.cartItems = false;
                        $scope.cartTotals = false;
                        $$('#page-cart .not-found').addClass('blank-state');
                        return;
                    } 

                    $scope.getCartTotals(); // Re-calculate cart totals

                    // Swiper Slider remove item from DOM
                    if ($$(".cart-items-swipe")[0]) {
                        var mySwiper = $$('.cart-items-swipe .swiper-container')[0].swiper;
                        mySwiper.removeSlide(mySwiper.activeIndex);
                        mySwiper.update(true);
                    }

                    // Swipeout remove item from DOM
                    MyApp.fw7.app.swipeoutDelete("#"+cart_item_key+"");

                    MyApp.fw7.app.addNotification({
                        title: 'Item Removed!',
                        message: 'An item was successfully removed from your cart.'
                    });
                } else {
                    MyApp.fw7.app.addNotification({
                        title: 'Error!',
                        message: response
                    });
                }
            }, function(error) {
                // console.log(error);

                MyApp.fw7.app.addNotification({
                    title: 'Oh Snap!',
                    message: 'Something went wrong, we are unable to fulfill your request at the moment.'
                });
            })
        });
    }

    // Empty the cart
    $scope.emptyCart = function() {
        MyApp.fw7.app.confirm('Are you sure about removing all cart items?', 'Empty Cart',function () {
            MyApp.fw7.app.showProgressbar(progressContainer, 'multi');

            customData.post( {action: MyApp.config.cartAction, endpoint: 'empty_cart', security: dtcwm_vars.dtcwm_cart_nonce} ).then(function(response) {
                MyApp.fw7.app.hideProgressbar();
                // console.log(response);

                if ( response.success == 1 ) {
                    // Clear old data
                    $scope.cartItems = false;
                    $scope.cartTotals = false;

                    $localStorage.cartTotal = 0; // update cart totals

                    $$('#page-cart .not-found').addClass('blank-state');

                    MyApp.fw7.app.addNotification({
                        title: 'Cart Emptied!',
                        message: 'Your shopping cart was cleared successfully.'
                    });
                } else {
                    MyApp.fw7.app.addNotification({
                        title: 'Error!',
                        message: response
                    });
                }
            }, function(error) {
                MyApp.fw7.app.hideProgressbar();
                // console.log(error);

                MyApp.fw7.app.addNotification({
                    title: 'Oh Snap!',
                    message: 'Something went wrong, we are unable to fulfill your request at the moment.'
                });
            })
        });
    }

    // Pull to refresh content
    var pullTrigger = $$('#page-cart .pull-to-refresh-content');
    pullTrigger.on('refresh', function() {
        // clear old data
        $scope.cartItems = false;
        $scope.cartTotals = false;

        initLoad.trigger();

        MyApp.fw7.app.pullToRefreshDone();
    });
}])





/**
 * Checkout Controller
 *-------------------------------------------- */
.controller('CheckoutCtrl', ['$scope', function($scope) {

    // Check shipping checkbox
    var isChecked = $$('#shipping-selected').prop('checked');
    if ( isChecked ) {
        $$('#shipping-address').show();
    } else {
        $$('#shipping-address').hide();
    }

    // Shipping on change event
    $$('#shipping-selected').change(function() {
        if ( this.checked == true ) {
            $$('#shipping-address').show();
        } else {
            $$('#shipping-address').hide();
        }
    });

    $$('a.woocommerce-remove-coupon').hide();
}])