<?php global $dtcwm_settings_config, $dtcwm_device_detect; ?>

<div class="navbar">
    <div class="navbar-inner">
        <div class="left">
            <?php if ( true == dtcwm_nav_layout_check( 'sidepanel' ) ) { ?>
            <a href="#" class="link ajax icon-only open-panel">
                <i class="icon {{deviceIos ? 'wm-ios-menu' : 'wm-android-menu'}}"></i>
            </a>
            <?php } ?>
        </div>
        <div class="center">Checkout</div>
        <div class="right">
            <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
            <a ng-if="deviceAndroid" href="#search" class="link icon-only">
                <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
            </a>
            <?php } ?>

            <a href="#cart" class="link icon-only">
                <span class="theme-color-text cart-badge" ng-bind="cartTotalShow"></span>
                <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
            </a>
        </div>

        <?php if ( $dtcwm_device_detect->isiOS() ) { ?>
        <div class="subnavbar">
            <div class="buttons-row">
                <a href="#checkout-login" class="button active tab-link">Sign In</a>
                <a href="#checkout-register" class="button tab-link">Create Account</a>
            </div>
        </div>
        <?php } ?>

    </div>
</div>

<?php if ( ! $dtcwm_device_detect->isiOS() ) { ?>
<div class="toolbar tabbar">
    <div class="toolbar-inner">
    <a href="#checkout-login" class="tab-link active">Sign In</a>
    <a href="#checkout-register" class="tab-link">Create Account</a>
    </div>
</div>
<?php } ?>

<?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>

<div class="bg-white tabs-swipeable-wrap swiper-container swiper-container-horizontal">
    <div class="tabs swiper-wrapper">
        
        <div id="checkout-login" class="page-content tab swiper-slide active swiper-slide-active">

            <div class="login-screen-content">
                <div class="login-screen-title">Sign In<span>Log into your account</span></div>

                <form ng-submit="authLogin()" class="hide-keypad">
                    <input type="hidden" ng-init="loginData.redirect = 'checkout'" ng-value="loginData.redirect" />
                    <div class="list-block inputs-list mb-10">
                        <ul>
                            <li class="item-content">
                                <div class="item-inner">
                                    <div class="item-title label">Username</div>
                                    <div class="item-input item-input-field">
                                        <input type="text" ng-model="loginData.username" placeholder="Your username">
                                    </div>
                                </div>
                            </li>
                            <li class="item-content">
                                <div class="item-inner">
                                    <div class="item-title label">Password</div>
                                    <div class="item-input item-input-field">
                                        <input type="password" ng-model="loginData.password" placeholder="Your password">
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="content-block">
                        <button type="submit" class="button button-big button-block button-fill button-raised">Sign In</button>
                    </div>

                    <div class="content-block">
                        <div class="list-block-label"><a href="<?php echo wp_lostpassword_url(); ?>" class="external">Forgot your password?</a></div>
                    </div>

                </form>
            </div>

        </div>
        <div id="checkout-register" class="page-content tab swiper-slide swiper-slide-next">

            <div class="login-screen-content">
                <div class="login-screen-title">
                    Sign Up!
                    <span>Register for an account</span>
                </div>

                <form ng-submit="authRegister()" class="hide-keypad"> 
                    <input type="hidden" ng-init="registerData.redirect = 'checkout'" ng-value="registerData.redirect" />
                    <div class="list-block inputs-list">
                        <ul>
                            <?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>
                            <li class="item-content">
                                <div class="item-inner">
                                    <div class="item-title label">Username</div>
                                    <div class="item-input item-input-field">
                                        <input type="text" ng-model="registerData.username" placeholder="Your username">
                                    </div>
                                </div>
                            </li>
                            <?php endif; ?>

                            <li class="item-content">
                                <div class="item-inner">
                                    <div class="item-title label">Email address</div>
                                    <div class="item-input item-input-field">
                                        <input type="email" ng-model="registerData.email" placeholder="Your email address">
                                    </div>
                                </div>
                            </li>

                            <?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>
                            <li class="item-content">
                                <div class="item-inner">
                                    <div class="item-title label">Password</div>
                                    <div class="item-input item-input-field">
                                        <input type="password" ng-minlength="7" ng-model="registerData.password" placeholder="Your password">
                                    </div>
                                </div>
                            </li>
                            <?php endif; ?>

                        </ul>
                    </div>
                    <div class="content-block">
                        <button type="submit" class="button button-big button-block button-fill button-raised">Register</button>
                    </div>
                </form>
            </div>

        </div>

    </div>
</div>