<?php 
if ( ! defined( 'ABSPATH' ) )
    exit;
?>

<div ng-if="products">
    <div ng-if="$storage.catalogLayout == 'grid'" class="product-grid">
        <div class="row">
            <div ng-repeat="item in products" class="col-50">
                <div class="card">
                    <div class="card-content">
                        <a href="#view-product" ng-click="$storage.productView = item.id">
                            <div ng-if="item.sale_price" class="sale-label">sale</div>
                            <img ng-if="!item.featured_src" src="<?= woocommerce_placeholder_img_src(); ?>"/>
                            <img ng-if="item.featured_src" ng-src="{{item.featured_src}}">
                        </a>
                    </div>
                    <div class="footer">
                        <div class="title" ng-bind-html="item.title | sanitize"></div>
                        <div class="price">
                            <span ng-bind-html="item.price_formated | sanitize"></span>
                            <?php if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) { ?>
                                <div class="star-rating pull-right">
                                    <span style="width:{{ ((item.average_rating / 5 ) * 100) }}%"></span>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div ng-if="$storage.catalogLayout == 'list'" class="product-list">
        <div class="list-block media-list">
            <ul>
                <li ng-repeat="item in products">
                    <a href="#view-product" ng-click="$storage.productView = item.id" class="item-link item-content">
                        <div class="item-media">
                            <div ng-if="item.sale_price" class="sale-label">sale</div>
                            <img ng-if="!item.featured_src" src="<?= woocommerce_placeholder_img_src(); ?>"/>
                            <img ng-if="item.featured_src" ng-src="{{item.featured_src}}">
                        </div>
                        <div class="item-inner">
                            <div class="item-title-row">
                                <div class="item-title" ng-bind-html="item.title | sanitize"></div>
                            </div>
                            <?php if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) { ?>
                                <div class="star-rating">
                                    <span style="width:{{ ((item.average_rating / 5 ) * 100) }}%"></span>
                                </div>
                            <?php } ?>
                            <div class="item-text product-price" ng-bind-html="item.price_formated | sanitize"></div>
                        </div>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>