<?php
/**
 * Hooks functions
 *-------------------------------------------- */
if ( ! defined( 'ABSPATH' ) )
    exit;

// Hide admin bar
add_filter('show_admin_bar', '__return_false');


// Redirect to Homepage upon log out
add_filter('logout_url', function ( $logouturl, $redir ) {
    $redir = get_option('siteurl');
    return $logouturl . '&amp;redirect_to=' . urlencode( $redir );
}, 10, 2);


// Redirect users on certain pages.
add_action( 'wp', 'page_redirect' );
function page_redirect() {
	if ( is_cart() ) {
		return wp_redirect( site_url().'#cart' );
	}

	if ( is_product() || is_product_tag() || is_product_category() ) {
		return wp_redirect( site_url() );
	}

}



/**
 * Add analytics tracking code below the </head>
 *------------------------------------------------------ */
function hook_analytics() {
	global $dtcwm_settings_config;
	if ( $dtcwm_settings_config['analytics'] ) {
		echo $dtcwm_settings_config['analytics'];
	}
}
add_action('wp_head','hook_analytics');



/**
 * Add custom js to the foot
 *-------------------------------------------- */
function hook_custom_js() {
	global $dtcwm_settings_config;
	
	if ( $dtcwm_settings_config['custom_code']['js'] ) { ?>
		<script type="text/javascript"><?= $dtcwm_settings_config['custom_code']['js']; ?></script>
	<?php 
	}
}
add_action('wp_footer','hook_custom_js', 100 );