<?php 
if ( ! defined( 'ABSPATH' ) )
    exit;

global $dtcwm_settings_config; 
?>

<div ng-controller="CartCtrl" data-page="cart" id="page-cart" class="page cached">
    
    <div class="navbar navbar-shadow">
        <div class="navbar-inner">
            <div class="left">
                <a href="#" class="back link icon-only">
                    <i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i>
                </a>
            </div>

            <div class="center sliding"><span class="title">My Cart</span></div>

            <div class="right">
                <a href="#" ng-click="emptyCart()" class="link icon-only" ng-click-once>
                    <i class="icon {{deviceIos ? 'wm-ios-trash' : 'wm-android-trash'}}"></i>
                </a>
            </div>
        </div>
    </div>

    <div ng-if="cartItems" ng-class="{'theme-color-bg':deviceIos == false}" class="toolbar toolbar-bottom">
        <div class="toolbar-inner">
            <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" ng-class="{'button-big':deviceIos == false}" class="button button-block button-fill external">Proceed to Checkout</a>
         </div>
    </div>

    <div class="page-content pull-to-refresh-content" data-ptr-distance="60">

        <?php 
        get_template_part( 'contents/content', 'pull_refresh' );
        get_template_part( 'contents/content', 'preloader' );
        get_template_part( 'contents/content', 'error_response' );
        ?>

        <div ng-if="cartItems" class="cart-items-swipe">

            <div class="text-center">
                Total: <span ng-bind-html="cartTotals.order_total | sanitize"></span>
            </div>

            <div class="swiper-container">
                <div class="swiper-wrapper">
                    
                    <div ng-repeat="item in cartItems" class="swiper-slide">
                        <div class="card">
                            <div class="card-content">
                                <a href="#" ng-click="removeItem(item.cart_item_key)" class="remove-item" ng-click-once>
                                    <i class="icon wm-android-close-circle"></i>
                                </a>
                                <div class="thumbnail" ng-bind-html="item.thumbnail | sanitize"></div>
                            </div>

                            <div class="card-footer">
                                <div class="row">
                                    <div class="col-70">
                                        Price: <span ng-bind-html="item.unit_price | sanitize"></span>
                                        <br>
                                        Total: <span ng-bind-html="item.total_price | sanitize"></span>
                                    </div>
                                    <div class="col-30">
                                        <div class="list-block inputs-list">
                                            <ul>
                                                <li class="item-content">
                                                    <div class="item-inner">
                                                        <div class="quantity-box">
                                                            <div class="item-title label">Qty</div>
                                                            <div class="item-input item-input-field">
                                                                <input id="product-{{item.product_id}}" ng-click="updateQuantity(item.product_id, item.cart_item_key)" type="text" value="{{item.quantity}}" readonly="readonly"/>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>                                        
                                </div>
                                <div class="title" ng-bind-html="item.title | sanitize"></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="hidden not-found">
            <div class="content-block text-center">
                <div class="empty-icon">
                    <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
                </div>
                <h2>Your cart is empty</h2>
                <p>but doesn't have to be.</p>
                <a href="#category" class="button button-big button-fill button-round button-raised">Start Shopping</a>
            </div>
        </div>

    </div>

</div>