<?php 
if ( ! defined( 'ABSPATH' ) )
    exit;

global $dtcwm_settings_config, $dtcwm_device_detect; 
?>
<div ng-controller="CatalogCtrl" data-page="catalog" id="page-catalog" class="page with-subnavbar cached">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    
		    <div class="left">
		        <?php if ( true == dtcwm_nav_layout_check( 'sidepanel' ) ) { ?>
		        <a href="#" class="link icon-only open-panel">
		            <i class="icon {{deviceIos ? 'wm-ios-menu' : 'wm-android-menu'}}"></i>
		        </a>
		        <?php } ?>
		    </div>

		    <div class="center sliding"><span class="title"><?= $dtcwm_settings_config['site_title']; ?></span></div>
		    
		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		    
		</div>
		<div class="subnavbar no-pad-right">
			<div class="left">
				<span class="sub-title" ng-bind="categoryName"></span>
			</div>
			<div class="right">
				<a ng-if="$storage.catalogLayout == 'grid'" href="#" class="link icon-only veiw-sort" ng-click="$storage.catalogLayout = 'list'">
					<i class="icon sm wm-list-view"></i>
				</a>
				<a ng-if="$storage.catalogLayout == 'list'" href="#" class="link icon-only veiw-sort" ng-click="$storage.catalogLayout = 'grid'">
					<i class="icon sm wm-grid-view"></i>
				</a>
			</div>
	    </div>
	</div>

    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content infinite-scroll pull-to-refresh-content">
		<?php 
		get_template_part( 'contents/content', 'pull_refresh' );
		get_template_part( 'contents/content', 'preloader' );
		get_template_part( 'contents/content', 'error_response' );
		?>

        <div class="hidden not-found">
            <div class="content-block text-center">
            	<div class="empty-icon">
                	<i class="icon wm-empty-info"></i>
                </div>
                <h2>No Products Found</h2>
                <p>Sorry, this category is currently empty.</p>
                <a href="#category" class="button button-big button-fill button-round button-raised">Back to categories</a>
            </div>
        </div>

		<?php 
		get_template_part( 'contents/content', 'product_listing' );
		get_template_part( 'contents/content', 'infinite_scroll' ); 
		?>
	</div>
</div>