<?php 
if ( ! defined( 'ABSPATH' ) ) 
	exit;

global $dtcwm_settings_config, $dtcwm_device_detect; 
?>

<div ng-controller="CategoryCtrl" data-page="category" id="page-category" class="page cached">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    
		    <div class="left">
		        <?php if ( true == dtcwm_nav_layout_check( 'sidepanel' ) ) { ?>
		        <a href="#" class="link icon-only open-panel">
		            <i class="icon {{deviceIos ? 'wm-ios-menu' : 'wm-android-menu'}}"></i>
		        </a>
		        <?php } ?>
		    </div>

		    <div class="center sliding"><span class="title">All Categories</span></div>
		    
		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		    
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">
		<?php
	        $taxonomy = 'product_cat';
	        $orderby = 'name';  
	        $show_count = 1;
	        $pad_counts = 1;
	        $hierarchical = 1;
	        $title = '';  
	        $empty = 0;

	        $cat_args = array(
	            'taxonomy'     => $taxonomy,
	            'orderby'      => $orderby,
	            'show_count'   => $show_count,
	            'pad_counts'   => $pad_counts,
	            'hierarchical' => $hierarchical,
	            'title_li'     => $title,
	            'hide_empty'   => $empty
	        );

	        $categories_list = get_categories( $cat_args );
	    ?>

	    <?php if ( $categories_list ) { ?>
		    <div id="category-list" >
			    <div class="content-block-title">Categories</div>
			    <div class="list-block media-list bg-white">
			        <ul>
			            <?php foreach ($categories_list as $category) {
			                if( $category->category_parent == 0 ) {
			                    $sub_cat_args = array(
			                        'taxonomy'     => $taxonomy,
			                        'child_of'     => 0,
			                        'parent'       => $category->term_id,
			                        'orderby'      => $orderby,
			                        'show_count'   => $show_count,
			                        'pad_counts'   => $pad_counts,
			                        'hierarchical' => $hierarchical,
			                        'title_li'     => $title,
			                        'hide_empty'   => $empty
			                    );
			                    $sub_category_list = get_categories( $sub_cat_args );

			                    $category_thumbnail_id = get_woocommerce_term_meta($category->term_id, 'thumbnail_id', true);
								$category_image = wp_get_attachment_url($category_thumbnail_id);
			                ?>
								<?php if( $sub_category_list ) { ?>
			                        <li class="accordion-item">
			                            <a href="#" class="item-content item-link">
											<div class="item-media">
												<?php if ( $category_image ) { ?>
													<img src="<?= esc_url($category_image); ?>" alt="*">
												<?php } else { ?>
													<div class="icon-image theme-color-bg"><i class="icon wm-empty-image"></i></div>
												<?php } ?>
											</div>
											<div class="item-inner">
												<div class="item-title-row">
													<div class="item-title"><?= $category->name; ?></div>
												</div>
												<div class="item-subtitle"><?= $category->description; ?></div>
											</div>
			                            </a>
			                            <div class="accordion-item-content">
			                                <div class="content-block">
			                                    <div class="list-block">
			                                        <ul>
			                                            <?php foreach ($sub_category_list as $sub_category) { 
										                    $sub_cat_thumbnail_id = get_woocommerce_term_meta($sub_category->term_id, 'thumbnail_id', true);
															$sub_cat_image = wp_get_attachment_url($sub_cat_thumbnail_id);
			                                           	?>
														<li class="direct">
			                                                <a ng-click="setCategory('<?= $sub_category->name; ?>', '<?= $sub_category->slug; ?>')" href="#catalog" class="item-link item-content">
			                                                    <div class="item-media">
			                                    				<?php if ( $sub_cat_image ) { ?>
																	<img src="<?= esc_url($sub_cat_image); ?>" alt="*">
																<?php } else { ?>
																	<div class="icon-image theme-color-bg"><i class="icon wm-empty-image"></i></div>
																<?php } ?>
																</div>
																<div class="item-inner">
																	<div class="item-title-row">
																		<div class="item-title"><?= $sub_category->name; ?></div>
																		<div class="item-after list-badge"><span class="badge theme-color-bg"><?= $sub_category->count; ?></span></div>
																	</div>
																	<div class="item-subtitle"><?= $sub_category->description; ?></div>
																</div>
			                                                </a>
			                                            </li>
			                                            <?php } ?>
			                                        </ul>
			                                    </div>
			                                </div>
			                            </div>
			                        </li>
			                    <?php } else { ?>
									<li class="direct">
										<a ng-click="setCategory('<?= $category->name; ?>', '<?= $category->slug; ?>')" href="#catalog" class="item-link item-content">
											<div class="item-media">
												<?php if ( $category_image ) { ?>
													<img src="<?= esc_url($category_image); ?>" alt="*">
												<?php } else { ?>
													<div class="icon-image theme-color-bg"><i class="icon wm-empty-image"></i></div>
												<?php } ?>
											</div>
											<div class="item-inner">
												<div class="item-title-row">
													<div class="item-title"><?= $category->name; ?></div>
													<div class="item-after list-badge"><span class="badge theme-color-bg"><?= $category->count; ?></span></div>
												</div>
												<div class="item-subtitle"><?= $category->description; ?></div>
											</div>
										</a>
									</li>
			                    <?php } ?>

			                <?php } ?>
			            <?php } ?>
			        </ul>
			    </div>
		    </div>
		<?php } else { ?>
	        <div class="blank-state">
	            <div class="content-block text-center">
	                <div class="empty-icon">
	                    <i class="icon wm-empty-info"></i>
	                </div>
	                <h2>No Categories Found</h2>
	                <p>Why not browse the catalog?</p>
	                <a href="#catalog" class="button button-big button-fill button-round button-raised">Browse Catalog</a>
	            </div>
	        </div>
		<?php } ?>
	</div>
</div>