<?php 
if ( ! defined( 'ABSPATH' ) )
	exit;

global $dtcwm_settings_config, $dtcwm_device_detect;
?>

<div ng-controller="ViewProductCtrl" data-page="view-product" id="page-view-product" class="page navbar-transparent cached">

    <div class="navbar no-border">
        <div class="navbar-inner">
            <div class="left">
                <a href="#" class="back link icon-only">
                    <i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i>
                </a>
            </div>

            <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

            	<a href="#cart" id="cart-link" class="link icon-only">
		        	<span class="cart-badge" ng-bind="$storage.cartTotal"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
            </div>
        </div>
    </div>

    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>

	<div class="page-content">

		<div ng-if="data">
			<div class="swiper-container">
				<div class="swiper-wrapper">
					<div ng-repeat="img in data.product.images" class="swiper-slide">
						<img class="img-responsive" ng-src="{{img.src}}" ng-click="viewGallery(data.product.images)" ng-click-once>
					</div>
				</div>
				<div class="swiper-pagination"></div>
			</div>

			<div class="product-overview content-block bg-white">
				<div class="content-block-inner">

					<div class="title">
						<h3><span ng-bind-html="data.product.title | sanitize"></span> <span ng-if="data.product.sale_price" class="sale-label pull-right">sale</span></h3>
					</div>

					<div class="pricing-rating row">
						<div class="col-50">
							<div class="product-price" ng-bind-html="data.product.price_html | sanitize"></div>
						</div>
	                    <?php if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) { ?>
	                    	<div class="col-50">
								<div class="product-rating pull-right text-right">
			                        <div class="star-rating">
			                            <span style="width:{{ ((data.product.average_rating / 5 ) * 100) }}%"></span>
			                        </div>
		                        </div>
	                        </div>
	                    <?php } ?>
					</div>

					<div class="product-excerpt" ng-bind-html="data.product.short_description | sanitize"></div>

					<form ng-if="data.product.type != 'external'" name="orderForm" ng-submit="addToCart()">
						
						<div ng-if="data.product.type == 'variable'" class="variable-item list-block">
							<ul>
								<li ng-repeat="item in data.attributes">
									<a href="#" class="item-link smart-select" data-open-in="picker" data-back-on-select="true">
										<select 
											ng-init="orderData.variation[item.slug] = item.selected"
											ng-model="orderData.variation[item.slug]"
											ng-options="opt for opt in item.options"
											ng-change="variationSelect()">
										</select>

										<div class="item-content">
											<div class="item-inner">
												<div class="item-title" ng-bind="item.name"></div>
												<div class="item-after" ng-bind="item.selected"></div>
											</div>
										</div>
									</a>
								</li>
							</ul>
						</div>

						<div ng-if="data.product.type != 'grouped'">
							<div ng-if="data.product.in_stock" class="row">
								<div ng-if="!data.product.sold_individually" class="col-30">
									<div class="quantity-input list-block inputs-list">
									    <ul>
									        <li class="item-content">
									            <div class="item-inner">
									            	<div class="quantity-box">
										                <div class="item-title label">Qty</div>
										                <div class="item-input item-input-field">
										                    <input type="text" name="quantity" id="product-{{data.product.id}}" ng-init="orderData.quantity = 1" ng-model="orderData.quantity" readonly="readonly"/>
														</div>
													</div>
									            </div>
									        </li>
									    </ul>
									</div>
								</div>
								<div ng-class="(data.product.sold_individually ? 'col-100' : 'col-70')">
									<button type="submit" name="addCart" class="button button-fill button-big button-raised button-block" ng-click-once>Add to cart</button>
								</div>
							</div>
						</div>

						<div ng-if="!data.product.in_stock" class="out-stock text-center">Out of stock</div>

						<div ng-if="data.product.type == 'grouped'" class="group-item">
							<div ng-repeat="item in data.product.grouped_products" class="row">
								<div class="col-25">
									<div class="quantity-input list-block inputs-list">
									    <ul>
									        <li ng-class="{'disabled':item.in_stock == false}" class="item-content">
									            <div class="item-inner">
									            	<div class="quantity-box">
										                <div class="item-title label">Qty</div>
										                <div class="item-input item-input-field">
										                    <input type="text" id="product-{{item.id}}" placeholder="0" ng-model="orderData.grouped[item.id]"/>
														</div>
													</div>
									            </div>
									        </li>
									    </ul>
									</div>
								</div>
								<div class="col-75">
									<div ng-class="{'disabled':item.in_stock == false}" class="title" ng-bind-html="item.title | sanitize"></div>
									<div>
										<span ng-class="{'disabled':item.in_stock == false}" ng-bind-html="item.price_html | sanitize" class="product-price"></span>
										<span class="out-stock" ng-if="item.in_stock == false">Out of stock</span>
									</div>
								</div>
							</div>

							<button type="submit" name="addCart" class="button button-fill button-big button-raised button-block" ng-click-once>Add to cart</button>
						</div>

					</form>

					<a ng-if="data.product.type == 'external'" href="{{data.product.product_url}}" rel="nofollow" target="_blank" class="button button-big button-fill button-raised external" ng-bind="data.product.button_text"></a>

				</div>
			</div>

			<div class="product-details content-block bg-white">
				<div class="content-block-inner">

					<span ng-if="data.product.description" class="product-description">
						<div class="title"><h3>Description</h3></div>
						<p ng-bind-html="data.product.description | sanitize"></p>
					</span>

					<div ng-if="data.product.dimensions_data.length" class="addtional-info list-block">
						<ul>
							<li ng-repeat="item in data.product.dimensions_data" class="item-content">
								<div class="item-inner">
									<div class="item-title" ng-bind="item.name"></div>
									<div class="item-after theme-color-bg badge" ng-bind="item.value"></div>
								</div>
							</li>
						</ul>
					</div>

				</div>
			</div>
		</div>

	    <?php 
	    get_template_part( 'contents/content', 'preloader' );
	    get_template_part( 'contents/content', 'error_response' );
	    ?>

	    <div class="hidden not-found">
	        <div class="content-block text-center">
	            <div class="empty-icon">
	                <i class="icon wm-empty-info"></i>
	            </div>
	            <h2>Product Not Found</h2>
	            <p>The product you have requested cannot be found.</p>
	            <a href="#" class="back button button-big button-fill button-round button-raised">Go Back</a>
	        </div>
	    </div>

	</div>
</div>