<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

wc_print_notices();

global $dtcwm_settings_config, $dtcwm_device_detect; 
?>

<div ng-controller="CheckoutCtrl" id="page-checkout" class="page with-subnavbar">
<?php 
if ( ! is_user_logged_in() && ! $checkout->enable_guest_checkout ) {
	get_template_part( 'contents/content', 'checkout_auth' );
}
else {  ?>
	<div class="navbar">
	    <div class="navbar-inner">
	        <div class="left">
	        	<?php if ( true == dtcwm_nav_layout_check( 'sidepanel' ) ) { ?>
	            <a href="#" class="link ajax icon-only open-panel">
	                <i class="icon {{deviceIos ? 'wm-ios-menu' : 'wm-android-menu'}}"></i>
	            </a>
	            <?php } ?>
	        </div>

	        <div class="center">Checkout</div>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
	    	
	    	<?php if ( $dtcwm_device_detect->isiOS() ) { ?>
	        <div class="subnavbar">
	            <div class="buttons-row">
	                <a href="#checkout-billing" class="button active tab-link">Billing</a>
	                <a href="#checkout-payment" class="button tab-link">Payment</a>
	                <a href="#checkout-confirm" class="button tab-link">Confirm</a>
	            </div>
	        </div>
	        <?php } ?>

	    </div>
	</div>

	<?php if ( ! $dtcwm_device_detect->isiOS() ) { ?>
	<div class="toolbar tabbar navbar-shadow">
	    <div class="toolbar-inner">
	    <a href="#checkout-billing" class="tab-link active">Billing</a>
	    <a href="#checkout-payment" class="tab-link">Payment</a>
	    <a href="#checkout-confirm" class="tab-link">Confirm</a>
	    </div>
	</div>
	<?php } ?>

	<?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<form name="checkout" method="post" class="hide-keypad" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
	 
	    <div class="tabs-swipeable-wrap swiper-container swiper-container-horizontal">
	        <div class="tabs swiper-wrapper">

	            <div id="checkout-billing" class="page-content tab swiper-slide active swiper-slide-active">

	                <!-- Billing -->
	                <?php if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>
	                    <?php if ( wc_ship_to_billing_address_only() && WC()->cart->needs_shipping() ) : ?>
	                        <div class="content-block-title"><?php _e( 'Billing &amp; Shipping', 'woocommerce' ); ?></div>
	                    <?php else : ?>
	                        <div class="content-block-title"><?php _e( 'Billing Details', 'woocommerce' ); ?></div>
	                    <?php endif; ?>

	                    <div class="bg-white content-block">
	                    	<div class="content-block-inner custom-inputs pb-0">
	      					<?php 
	                            foreach ( $checkout->checkout_fields['billing'] as $key => $field ) :
	                            woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
	                            endforeach; 
	                        ?>
	                        <div class="clearfix"></div>
	                        </div>
	                    </div>
	                <?php endif; ?>

	                <!-- Shipping -->
	                <?php if ( true === WC()->cart->needs_shipping_address() ) { ?>
	                <div class="shipping-block">
		                <div class="row">
		                	<div class="col-70">
		                		<div class="content-block-title ios-lowercase">Ship to a different address?</div>
		                	</div>
		                	<div class="col-30">
								<div class="item-input switcher">
									<label class="label-switch">
										<input id="shipping-selected" name="ship_to_different_address" value="1" <?php checked( apply_filters( 'woocommerce_ship_to_different_address_checked', 'shipping' === get_option( 'woocommerce_ship_to_destination' ) ? 1 : 0 ), 1 ); ?> type="checkbox">
										<div class="checkbox"></div>
									</label>
								</div>
		                	</div>
						</div>

		                <div class="bg-white content-block">
		                    <div class="content-block-inner custom-inputs">
								<div id="shipping-address">
			                    <?php 
			                    foreach ( $checkout->checkout_fields['shipping'] as $key => $field ) :
			                        woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
			                    endforeach; 
			                    ?>
			                    <div class="clearfix"></div>
			                    </div>

				                <?php if ( apply_filters( 'woocommerce_enable_order_notes_field', get_option( 'woocommerce_enable_order_comments', 'yes' ) === 'yes' ) ) : ?>
				                	<?php foreach ( $checkout->checkout_fields['order'] as $key => $field ) : 
			                            woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
			                        endforeach; ?>
								<?php endif; ?>
							</div>
						</div>
					</div>
	                <?php } else { ?>

						<?php if ( apply_filters( 'woocommerce_enable_order_notes_field', get_option( 'woocommerce_enable_order_comments', 'yes' ) === 'yes' ) ) : ?>
		                    <div class="content-block-title"><?php _e( 'Additional Information', 'woocommerce' ); ?></div>
		                  	<div class="bg-white content-block">
		                    	<div class="content-block-inner custom-inputs">
									<?php 
			                        foreach ( $checkout->checkout_fields['order'] as $key => $field ) : 
			                            woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
			                        endforeach; 
			                        ?>
								</div>
							</div>
						<?php endif; ?>

					<?php } ?>
	            </div>

	            <div id="checkout-payment" class="page-content tab swiper-slide swiper-slide-next">
	                
	                <!-- Payment -->
	                <div class="content-block-title">Payment Method</div>
	                <?php if ( WC()->cart->needs_payment() ) :
	                    $available_gateways = WC()->payment_gateways()->get_available_payment_gateways();
	                    WC()->payment_gateways()->set_current_gateway( $available_gateways );
	                
	                    if ( ! empty( $available_gateways ) ) { ?>
	                        <div class="bg-white payment-radio list-block media-list">
	                            <ul>
	                                <?php foreach ( $available_gateways as $gateway ) { ?>
	                                <li>
	                                    <label class="label-radio item-content">
	                                        <input id="payment_method_<?php echo $gateway->id; ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?>" />
	                                        <div class="item-media">
	                                            <i class="icon icon-form-radio"></i>
	                                        </div>
	                                        <div class="item-inner">
	                                            <div class="item-title-row">
	                                                <div class="item-title"><?php echo $gateway->get_title(); ?></div>
	                                            </div>
	                                            <div class="item-text"><?php $gateway->payment_fields(); ?></div>
	                                        </div>
	                                    </label>
	                                </li>
	                                <?php } ?>
	                            </ul>
	                        </div>
	                    <?php } else { ?>
	                        <?php echo apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_country() ? __( 'Sorry, it seems that there are no available payment methods for your state. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : __( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) ) ; ?>
	                    <?php } ?>
	                <?php endif; ?>

	            </div>

	            <div id="checkout-confirm" class="page-content tab swiper-slide">

					<!-- Coupon -->
	                <?php if ( empty( WC()->cart->applied_coupons ) ) { ?>
	                <div class="content-block mb-0">
	                    <form action="" class="checkout_coupon" method="post">
	                    	<div class="row">
	                    		<div class="col-70 custom-inputs">
	                        		<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon Code', 'woocommerce' ); ?>" id="coupon_code" value="" />
	                        	</div>
	                        	<div class="col-30">
									<input type="submit" class="button button-raised coupon-btn" name="apply_coupon" value="Apply" />
	                        	</div>
	                        </div>
	                    </form>
	            	</div>
	                <?php } ?>

	                <div class="content-block-title">Your Order</div>
	                <div class="bg-white list-block list-show-title">
	                    <ul>
	                        <?php 
	                        foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
	                        $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );

	                        if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
	                        ?>
	                        <li class="item-content">
	                            <div class="item-inner">
	                                <div class="item-title">
	                                    <?php echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ) . '&nbsp;'; ?>
	                                    <?php echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( '&times; %s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key ); ?>
	                                    <?php echo WC()->cart->get_item_data( $cart_item ); ?>
	                                </div>
	                                <div class="item-after"><?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); ?></div>
	                            </div>
	                        </li>
	                        <?php
	                            }
	                        } ?>
	                    </ul>
	                </div>

					<div class="content-block-title">Payment Summary</div>
					<div class="content-block">
					    <div class="content-block-inner bg-white">

							<table class="list-table">
								<tbody>
									<tr class="cart-subtotal">
										<th><?php _e( 'Subtotal', 'woocommerce' ); ?></th>
										<td><?php wc_cart_totals_subtotal_html(); ?></td>
									</tr>

									<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
										<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
											<th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
											<td><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
										</tr>
									<?php endforeach; ?>

									<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
										<?php wc_cart_totals_shipping_html(); ?>
									<?php endif; ?>

									<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
										<tr class="fee">
											<th><?php echo esc_html( $fee->name ); ?></th>
											<td><?php wc_cart_totals_fee_html( $fee ); ?></td>
										</tr>
									<?php endforeach; ?>

									<?php if ( wc_tax_enabled() && 'excl' === WC()->cart->tax_display_cart ) : ?>
										<?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
											<?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
												<tr class="tax-rate tax-rate-<?php echo sanitize_title( $code ); ?>">
													<th><?php echo esc_html( $tax->label ); ?></th>
													<td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
												</tr>
											<?php endforeach; ?>
										<?php else : ?>
											<tr class="tax-total">
												<th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
												<td><?php wc_cart_totals_taxes_total_html(); ?></td>
											</tr>
										<?php endif; ?>
									<?php endif; ?>

									<tr class="order-total">
										<th><?php _e( 'Total', 'woocommerce' ); ?></th>
										<td><?php wc_cart_totals_order_total_html(); ?></td>
									</tr>
								</tbody>
							</table>

						</div>
					</div>


					<div class="content-block">
						<input type="submit" class="button button-big button-fill button-raised" name="woocommerce_checkout_place_order" id="place_order" value="Place Order" />
	           		</div>

	                <?php wp_nonce_field( 'woocommerce-process_checkout' ); ?>
	            </div>

	        </div>
	    </div>
	</form>
<?php } 
?>
</div>