<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div ng-controller="CheckoutCtrl" id="page-thankyou" class="page">
	<div class="page-content bg-white">


<?php
if ( $order ) : ?>

	<?php if ( $order->has_status( 'failed' ) ) : ?>

		<div class="blank-state">
		    <div class="content-block text-center">
				<h2>Order Failed!</h2>
		        <p>Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.</p>
		        <br>
		    
			    <a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button button-big button-fill button-round button-raised external">Re-try Payment</a>
				
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button button-big button-round button-raised external">My Account</a>
				<?php endif; ?>
			</div>
		</div>

	<?php else : ?>

	    <div class="text-center">
	    	<i class="icon wm-done-all theme-color-text font-lg"></i>
			<h2 class="mb-0">Thank You!</h2>
	        <p class="mt-0">Your order has been received.</p>
	        <p>Order Number: <strong>#<?php echo $order->get_order_number(); ?></strong></p>
	        <br>
	    </div>

		<div class="content-block mt-0">
			<?php do_action( 'woocommerce_thankyou_' . $order->payment_method, $order->id ); ?>
		
			<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>" class="button button-big button-fill button-round button-raised external">Manage Orders</a>
		</div>

	<?php endif; ?>

<?php else : ?>

	<div class="blank-state">
	    <div class="content-block text-center">
			<h2>Thank You!</h2>
	        <p>Your order has been received.</p>
	        <br>
	        <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>" class="button button-big button-fill button-round button-raised external">Manage Orders</a>
	    </div>
	</div>

<?php endif; ?>


	</div>
</div>