<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $dtcwm_settings_config, $dtcwm_device_detect;
?>

<div id="page-downloads" class="page">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    <div class="left">
		        <a href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="external link icon-only"><i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i></a>
		    </div>

		    <div class="center sliding"><span class="title">Downloads</span></div>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">

		<?php
		$downloads     = WC()->customer->get_downloadable_products();
		$has_downloads = (bool) $downloads;
		?>

		<?php if ( $has_downloads ) : ?>
		<div class="list-block cards-list">
			<ul>

			<?php foreach ( $downloads as $download ) : ?>
				<li class="card">
					<div class="card-content">
						<div class="card-content-inner">

							<div class="mb-15"><?php echo esc_html( $download['download_name'] ); ?></div>
							<div>Remaining: 
								<?php
									if ( is_numeric( $download['downloads_remaining'] ) ) {
										echo esc_html( $download['downloads_remaining'] );
									} else {
										_e( '&infin;', 'woocommerce' );
									}
								?>
							</div>
							<div>Expires: 
								<?php if ( ! empty( $download['access_expires'] ) ) : ?>
									<time datetime="<?php echo date( 'Y-m-d', strtotime( $download['access_expires'] ) ); ?>" title="<?php echo esc_attr( strtotime( $download['access_expires'] ) ); ?>"><?php echo date_i18n( get_option( 'date_format' ), strtotime( $download['access_expires'] ) ); ?></time>
								<?php else : ?>
									<?php _e( 'Never', 'woocommerce' ); ?>
								<?php endif; ?>
							</div>

						</div>
					</div>
					<div class="card-footer">
						<?php
							$actions = array(
								'download'  => array(
									'url'  => $download['download_url'],
									'name' => __( 'Download', 'woocommerce' )
								)
							);

							if ( $actions = apply_filters( 'woocommerce_account_download_actions', $actions, $download ) ) {
								foreach ( $actions as $key => $action ) {
									echo '<a href="' . esc_url( $action['url'] ) . '" class="external ' . sanitize_html_class( $key ) . '">' . esc_html( $action['name'] ) . '</a>';
								}
							}
						?>
					</div>
				</li>
			<?php endforeach; ?>
			
			</ul>
		</div>
		
		<?php else : ?>
	        <div class="blank-state">
	            <div class="content-block text-center">
	                <div class="empty-icon">
	                    <i class="icon {{deviceIos ? 'wm-ios-download' : 'wm-android-download'}}"></i>
	                </div>
	                <h2>Downloads</h2>
	                <p>No downloads available yet.</p>
	            </div>
	        </div>
		<?php endif; ?>

	</div>
</div>