<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wc_print_notices(); ?>

<div id="page-lostpassword" class="page no-toolbar no-navbar">
	<div class="page-content login-screen-content">

		<div ng-if="deviceAndroid" class="back-page">
			<a href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="external"><i class="icon wm-android-arrow-left"></i></a>
		</div>

		<div ng-if="deviceIos" class="back-page">
			<a href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="external"><i class="icon wm-ios-arrow-left"></i></a>
		</div>

		<br><br><br><br>

	    <div class="login-screen-title">
	    	Lost Password
			<span>Recover your password</span>
		</div>

		<form action="" method="post" class="hide-keypad">
			<div class="list-block inputs-list mb-10">
			    <ul>
			        <li class="item-content">
			            <div class="item-inner">
			                <div class="item-title label">Details</div>
			                <div class="item-input item-input-field">
			                    <input type="text" name="user_login" id="user_login" placeholder="Your username or email">
			                </div>
			            </div>
			        </li>
			    </ul>
			</div>

		    <div class="content-block">
		    	<input type="hidden" name="wc_reset_password" value="true" />
		    	<button type="submit" class="button button-big button-block button-fill button-raised"><?php esc_attr_e( 'Reset Password', 'woocommerce' ); ?></button>
		    </div>

			<?php wp_nonce_field( 'lost_password' ); ?>
		</form>

	</div>
</div>
