<?php
/**
 * Lost password reset form.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-reset-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wc_print_notices(); ?>


<div id="page-resetpassword" class="page no-toolbar no-navbar">
	<div class="page-content login-screen-content">

		<br><br><br>
		
	    <div class="login-screen-title">
	    	Password Reset
			<span><?php echo apply_filters( 'woocommerce_reset_password_message', __( 'Enter a new password below.', 'woocommerce') ); ?></span>
		</div>

		<form action="" method="post" class="hide-keypad">
			<div class="list-block inputs-list mb-10">
	            <ul>
	                <li class="item-content">
	                    <div class="item-inner">
	                        <div class="item-title label"><?php _e( 'New password', 'woocommerce' ); ?></div>
	                        <div class="item-input item-input-field">
	                            <input type="password" name="password_1" id="password_1" placeholder="Your new password">
	                        </div>
	                    </div>
	                </li>
	                <li class="item-content">
	                    <div class="item-inner">
	                        <div class="item-title label">Confirm Password</div>
	                        <div class="item-input item-input-field">
	                            <input type="password" name="password_2" id="password_2" placeholder="Re-enter new password">
	                        </div>
	                    </div>
	                </li>
	            </ul>
	        </div>

			<input type="hidden" name="reset_key" value="<?php echo esc_attr( $args['key'] ); ?>" />
			<input type="hidden" name="reset_login" value="<?php echo esc_attr( $args['login'] ); ?>" />

			<div class="content-block">
				<input type="hidden" name="wc_reset_password" value="true" />
	        	<button type="submit" class="button button-big button-block button-fill button-raised"><?php esc_attr_e( 'Save', 'woocommerce' ); ?></button>
	        </div>

			<?php wp_nonce_field( 'reset_password' ); ?>

		</form>

	</div>
</div>