<?php
/**
 * Orders
 *
 * Shows orders on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/orders.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $dtcwm_settings_config, $dtcwm_device_detect;
?>
<div id="page-orders" class="page">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    <div class="left">
		        <a href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="external link icon-only"><i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i></a>
		    </div>

		    <div class="center sliding"><span class="title">Orders</span></div>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">
		<?php if ( $has_orders ) : ?>

			<div class="list-block cards-list">
				<ul>
				<?php foreach ( $customer_orders->orders as $customer_order ) :
					$order      = wc_get_order( $customer_order );
					$item_count = $order->get_item_count();
					?>

					<li class="card">
						<div class="card-content">
							<div class="card-content-inner">

								<div class="pull-left"><strong><?php echo _x( '#', 'hash before order number', 'woocommerce' ) . $order->get_order_number(); ?></strong></div>
								<div class="pull-right"><time datetime="<?php echo date( 'Y-m-d', strtotime( $order->order_date ) ); ?>" title="<?php echo esc_attr( strtotime( $order->order_date ) ); ?>"><?php echo date_i18n( get_option( 'date_format' ), strtotime( $order->order_date ) ); ?></time></div>
								<div class="clearfix mb-15"></div>

								<div>Status: <?php echo wc_get_order_status_name( $order->get_status() ); ?></div>
								<div>Total: <?php echo sprintf( _n( '%s for %s item', '%s for %s items', $item_count, 'woocommerce' ), $order->get_formatted_order_total(), $item_count ); ?></div>

							</div>
						</div>
						<div class="card-footer">
							<?php
								$actions = array(
									'pay'    => array(
										'url'  => $order->get_checkout_payment_url(),
										'name' => __( 'Pay', 'woocommerce' )
									),
									'view'   => array(
										'url'  => $order->get_view_order_url(),
										'name' => __( 'View', 'woocommerce' )
									),
									'cancel' => array(
										'url'  => $order->get_cancel_order_url( wc_get_page_permalink( 'myaccount' ) ),
										'name' => __( 'Cancel', 'woocommerce' )
									)
								);

								if ( ! $order->needs_payment() ) {
									unset( $actions['pay'] );
								}

								if ( ! in_array( $order->get_status(), apply_filters( 'woocommerce_valid_order_statuses_for_cancel', array( 'pending', 'failed' ), $order ) ) ) {
									unset( $actions['cancel'] );
								}

								if ( $actions = apply_filters( 'woocommerce_my_account_my_orders_actions', $actions, $order ) ) { ?>
									<?php
									foreach ( $actions as $key => $action ) {
										echo '<a href="' . esc_url( $action['url'] ) . '" class="external">' . esc_html( $action['name'] ) . '</a>';
									} ?>
								<?php
								}
							?>		
						</div>
					</li>

				<?php endforeach; ?>
				</ul>
			</div>

			<?php if ( 1 < $customer_orders->max_num_pages ) : ?>
				<div class="order-pagination content-block">
					<?php if ( 1 !== $current_page ) : ?>
						<a class="button button-fill button-big button-raised button-round external" href="<?php echo esc_url( wc_get_endpoint_url( 'orders', $current_page - 1 ) ); ?>"><?php _e( 'Previous', 'woocommerce' ); ?></a>
					<?php endif; ?>

					<?php if ( $current_page !== intval( $customer_orders->max_num_pages ) ) : ?>
						<a class="button button-fill button-big button-raised button-round external" href="<?php echo esc_url( wc_get_endpoint_url( 'orders', $current_page + 1 ) ); ?>"><?php _e( 'Next', 'woocommerce' ); ?></a>
					<?php endif; ?>
				</div>
			<?php endif; ?>

		<?php else : ?>
	        <div class="blank-state">
	            <div class="content-block text-center">
	                <div class="empty-icon">
	                    <i class="icon {{deviceIos ? 'wm-ios-order' : 'wm-android-order'}}"></i>
	                </div>
	                <h2>Orders</h2>
	                <p>No order has been made yet.</p>
	                <a href="#category" class="button button-big button-fill button-round button-raised">Start Shopping</a>
	            </div>
	        </div>
		<?php endif; ?>

	</div>
</div>
